/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes.interval;

import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueToolkit;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.interval.Messages;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.PolicyFactory;
import com.jrockit.mc.rjmx.subscription.internal.AttributeInfoManager;
import com.jrockit.mc.rjmx.subscription.internal.DefaultUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.OneShotUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.SimpleUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class UpdateIntervalWizard
extends WizardPage
implements IPerformFinishable {
    private final IConnectionHandle m_handle;
    private final AttributeDescriptor m_attributeDescriptor;
    private IUpdatePolicy m_policy;

    public UpdateIntervalWizard(IConnectionHandle handle, AttributeDescriptor descriptor) {
        super(Messages.UpdateIntervalWizard_WIZARD_PAGE_NAME);
        this.setTitle(Messages.UpdateIntervalWizard_SELECT_AN_UPDATE_INTERVAL_TITLE);
        this.m_handle = handle;
        this.m_attributeDescriptor = descriptor;
        this.m_policy = UpdatePolicyToolkit.getUpdatePolicy((IConnectionHandle)handle, (AttributeDescriptor)descriptor);
        this.setDescription(Messages.UpdateIntervalWizard_UPDATE_INTERVAL_WIZARD_DESCRIPTION_TEXT);
    }

    public void createControl(Composite parent) {
        this.createUpdateCombo(parent);
    }

    public boolean performFinish() {
        UpdatePolicyToolkit.setUpdatePolicy((IConnectionHandle)this.m_handle, (AttributeDescriptor)this.m_attributeDescriptor, (IUpdatePolicy)this.m_policy);
        return true;
    }

    private void createUpdateCombo(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 250;
        gd.heightHint = 150;
        container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 1, false, false);
        gd1.horizontalSpan = 2;
        Button oneTimePolicyButton = this.createOneTimePolicyButton(container);
        oneTimePolicyButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 1, false, false);
        gd2.horizontalSpan = 2;
        Button deafultPolicyButton = this.createDefaultPolicyButton(container);
        deafultPolicyButton.setLayoutData((Object)gd2);
        this.createCustomUpdatepolicy(container);
        this.setControl((Control)container);
    }

    protected void createCustomUpdatepolicy(Composite container) {
        GridData gd1 = new GridData(4, 4, false, false);
        final Button customPolicyButton = new Button(container, 16);
        customPolicyButton.setText(AttributeValueToolkit.UPDATE_INTERVAL_CUSTOM);
        customPolicyButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        final Text text = new Text(container, 2048);
        text.setLayoutData((Object)gd2);
        if (this.m_policy instanceof SimpleUpdatePolicy) {
            SimpleUpdatePolicy sup = (SimpleUpdatePolicy)this.m_policy;
            customPolicyButton.setSelection(true);
            text.setText(Integer.toString(sup.getUpdateTime()));
            text.setEditable(true);
        } else {
            text.setText(Integer.toString(AttributeInfoManager.getDefaultUpdateInterval()));
            customPolicyButton.setSelection(false);
            text.setEditable(false);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UpdateIntervalWizard.this.updateCustomPolicy(text);
            }
        });
        customPolicyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setEditable(customPolicyButton.getSelection());
                if (customPolicyButton.getSelection()) {
                    UpdateIntervalWizard.this.updateCustomPolicy(text);
                }
            }
        });
    }

    private static boolean isNumeric(String text) {
        try {
            int value = Integer.parseInt(text);
            return value > 0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private void updateCustomPolicy(Text text) {
        String textString = text.getText();
        if (UpdateIntervalWizard.isNumeric(textString)) {
            this.setValidPolicy(SimpleUpdatePolicy.newPolicy((int)Integer.parseInt(textString)));
        } else {
            this.setInValidPolicy(Messages.UpdateIntervalWizard_VALUE_MUST_POSITIVE_INTEGER_TEXT);
        }
    }

    private void setValidPolicy(IUpdatePolicy policy) {
        this.m_policy = policy;
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    private void setInValidPolicy(String errorMessage) {
        this.m_policy = null;
        this.setPageComplete(false);
        this.setErrorMessage(errorMessage);
    }

    protected Button createOneTimePolicyButton(Composite parent) {
        Button button = new Button(parent, 16);
        button.setText(AttributeValueToolkit.UPDATE_INTERVAL_ONCE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateIntervalWizard.this.setPolicy(PolicyFactory.createOneShotPolicy());
                UpdateIntervalWizard.this.setPageComplete(true);
            }
        });
        button.setSelection(this.m_policy instanceof OneShotUpdatePolicy);
        return button;
    }

    protected Button createDefaultPolicyButton(Composite parent) {
        Button button = new Button(parent, 16);
        button.setText(AttributeValueToolkit.UPDATE_INTERVAL_DEFAULT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdateIntervalWizard.this.setValidPolicy(DefaultUpdatePolicy.newPolicy());
            }
        });
        button.setSelection(this.m_policy instanceof DefaultUpdatePolicy);
        return button;
    }

    private void setPolicy(IUpdatePolicy policy) {
        this.m_policy = policy;
    }
}

