/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes.editors;

import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueToolkit;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.editors.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.editors.PositiveIntegerValidator;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTreeEditor;
import com.jrockit.mc.core.ui.fields.IFieldEditorControlFactory;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.PolicyFactory;
import com.jrockit.mc.rjmx.subscription.internal.AttributeInfoManager;
import com.jrockit.mc.rjmx.subscription.internal.SimpleUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class UpdateIntervalEditor
implements IFieldEditorControlFactory {
    private final IConnectionHandle m_handle;

    public UpdateIntervalEditor(IConnectionHandle handle) {
        this.m_handle = handle;
    }

    public Control createControl(FieldTreeEditor editor, Field field) {
        CCombo policySelector = new CCombo((Composite)editor.getViewer().getControl(), 0);
        policySelector.addSelectionListener(this.createPolicySelectionListener(editor));
        policySelector.setItems(AttributeValueToolkit.POLICY_ITEMS);
        this.setDefaultPolicyText(policySelector, editor.getViewer());
        policySelector.setFocus();
        return policySelector;
    }

    private void setDefaultPolicyText(CCombo policySelector, StructuredViewer viewer) {
        AttributeDescriptor ad = AttributeValueToolkit.extractFirstAttributeDescriptor((ISelectionProvider)viewer);
        if (ad != null) {
            policySelector.setText(AttributeValueToolkit.getUpdatePolicyText(this.m_handle, ad));
        }
    }

    private SelectionListener createPolicySelectionListener(FieldTreeEditor editor) {
        return new PolicySelectionListener(this.m_handle, editor);
    }

    private static class PolicySelectionListener
    extends SelectionAdapter {
        private final IConnectionHandle m_handle;
        private final AttributeDescriptor m_descriptor;
        private final StructuredViewer m_viewer;
        private final FieldTreeEditor m_editor;

        public PolicySelectionListener(IConnectionHandle handle, FieldTreeEditor editor) {
            this.m_handle = handle;
            this.m_viewer = editor.getViewer();
            this.m_descriptor = AttributeValueToolkit.extractFirstAttributeDescriptor((ISelectionProvider)editor.getViewer());
            this.m_editor = editor;
        }

        public void widgetSelected(SelectionEvent e) {
            if (!this.m_viewer.getSelection().isEmpty()) {
                CCombo policySelector = (CCombo)e.widget;
                switch (policySelector.getSelectionIndex()) {
                    case 0: {
                        this.setPolicy(PolicyFactory.createOneShotPolicy());
                        break;
                    }
                    case 1: {
                        this.setPolicy(PolicyFactory.createDefaultUpdatePolicy());
                        break;
                    }
                    default: {
                        this.selectCustomPolicy(policySelector.getShell());
                    }
                }
            }
            this.m_editor.disposeTreeEditor();
            this.m_viewer.refresh();
        }

        private void selectCustomPolicy(Shell shell) {
            InputDialog dialog = this.createInputDialog(shell, this.createCustomTime());
            if (dialog.open() == 0) {
                this.setPolicy(SimpleUpdatePolicy.newPolicy((int)Integer.parseInt(dialog.getValue())));
            }
        }

        private InputDialog createInputDialog(Shell shell, int updateTime) {
            return new InputDialog(shell, Messages.UpdateIntervalEditor_DIALOG_UPDATE_INTERVAL_TITLE, Messages.UpdateIntervalEditor_DIALOG_UPDATE_INTERVAL_TEXT, Integer.toString(updateTime), (IInputValidator)new PositiveIntegerValidator());
        }

        private int createCustomTime() {
            int updateTime = UpdatePolicyToolkit.getUpdateTime((IConnectionHandle)this.m_handle, (AttributeDescriptor)this.m_descriptor);
            return updateTime <= 0 ? AttributeInfoManager.getDefaultUpdateInterval() : updateTime;
        }

        private void setPolicy(IUpdatePolicy policy) {
            UpdatePolicyToolkit.setUpdatePolicy((IConnectionHandle)this.m_handle, (AttributeDescriptor)this.m_descriptor, (IUpdatePolicy)policy);
        }
    }
}

