/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes.editors;

import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueModel;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueToolkit;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.SingleValueInfo;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.ui.fields.FieldTreeEditor;
import com.jrockit.mc.core.ui.fields.IFieldEditorControlFactory;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AttributeValueEditor
implements IFieldEditorControlFactory {
    private final AttributeValueModel m_attributeHolder;

    public AttributeValueEditor(FieldTreeEditor editor, AttributeValueModel attributesHolder) {
        this.m_attributeHolder = attributesHolder;
    }

    public Control createControl(FieldTreeEditor editor, Field field) {
        Object object = editor.getSelected();
        Composite parent = (Composite)editor.getViewer().getControl();
        if (object instanceof IAttributeInfo) {
            return this.editValue(parent, (IAttributeInfo)object);
        }
        if (object instanceof SingleValueInfo) {
            return this.editValue(parent, ((SingleValueInfo)object).getAttributeInfo());
        }
        return null;
    }

    private Control editValue(Composite parent, final IAttributeInfo info) {
        ValueEditorFactory factory = new ValueEditorFactory();
        Class clazz = AttributeValueToolkit.getClassWithName(info);
        boolean editable = AttributeValueToolkit.isEditable(info);
        final ValueEditor ve = factory.createEditorForType(parent, clazz, editable, false);
        ve.setValue(this.m_attributeHolder.getValue(info));
        ve.setValueChangedCallback(new ValueChangedListener(){

            public void valueChanged(boolean sendUpdate) {
                Object value = ve.getValue();
                if (sendUpdate && value != null) {
                    AttributeValueEditor.this.m_attributeHolder.setAttributeValue(info, value);
                }
            }
        });
        return ve.activateEditing();
    }
}

