/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueModel;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorContext;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.SingleValueInfo;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenDataException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class AttributesTableInspectorContext
implements InspectorContext {
    private final ISelectionProvider m_provider;
    private final IConnectionHandle m_handle;
    private final AttributeValueModel m_model;
    static /* synthetic */ Class class$0;

    public AttributesTableInspectorContext(ISelectionProvider provider, IConnectionHandle handle, AttributeValueModel model) {
        this.m_provider = provider;
        this.m_handle = handle;
        this.m_model = model;
    }

    private Object getActiveElement() {
        if (((IStructuredSelection)this.m_provider.getSelection()).size() == 1) {
            return ((IStructuredSelection)this.m_provider.getSelection()).getFirstElement();
        }
        return null;
    }

    private boolean isEditable(IAttributeInfo info) {
        boolean isSubAttributeToWritableComposite = false;
        if (info.getAttributeDescriptor().isCompositeChild()) {
            isSubAttributeToWritableComposite = AttributeInfoToolkit.getCompositeParent((IConnectionHandle)this.m_handle, (IAttributeInfo)info).isWritable();
        }
        return info.isWritable() | isSubAttributeToWritableComposite;
    }

    public boolean canEdit() {
        Object element = this.getActiveElement();
        if (element instanceof IAttributeInfo) {
            return this.isEditable((IAttributeInfo)element);
        }
        if (element instanceof SingleValueInfo) {
            return ((SingleValueInfo)element).isEditable(new ValueEditorFactory());
        }
        return false;
    }

    public boolean canInspect() {
        Object element = this.getActiveElement();
        return element != null && (element instanceof IAttributeInfo || element instanceof SingleValueInfo);
    }

    public Class getTypeToInspect() {
        Class<?> clazz;
        Object activeElement = this.getActiveElement();
        if (activeElement instanceof IAttributeInfo) {
            IAttributeInfo info = (IAttributeInfo)activeElement;
            try {
                return TypeHandling.getClassWithName(info.getAttributeType());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        } else if (activeElement instanceof SingleValueInfo) {
            return ((SingleValueInfo)activeElement).getType();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object getValueToInspect() {
        Object element = this.getActiveElement();
        if (element instanceof IAttributeInfo) {
            return this.m_model.getValue((IAttributeInfo)element);
        }
        if (element instanceof SingleValueInfo) {
            return ((SingleValueInfo)element).getValue();
        }
        return null;
    }

    public void setValue(Object value) {
        try {
            this.setModelValue(value);
        }
        catch (Exception e) {
            DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AttributeValueToolkit_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)e);
        }
    }

    private void setModelValue(Object value) throws OpenDataException, InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        if (value != null) {
            Object element = this.getActiveElement();
            if (element instanceof IAttributeInfo) {
                this.m_model.setAttributeValue((IAttributeInfo)element, value);
            } else if (element instanceof SingleValueInfo) {
                SingleValueInfo info = (SingleValueInfo)element;
                IAttributeInfo attributeInfo = info.getAttributeInfo();
                Object attributeInfoValue = this.m_model.getValue(attributeInfo);
                info.setValue(attributeInfoValue, value);
                this.m_model.setAttributeValue(attributeInfo, this.m_model.getValue(attributeInfo));
            }
        }
    }
}

