/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueModel;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributesTableInspectorContext;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectorAction;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueChangedListener;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.ValueEditorFactory;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.AttributeValueInfo;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.DefaultUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.OneShotUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.SimpleUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AttributeValueToolkit {
    public static final String UPDATE_INTERVAL_ONCE = Messages.AttributeValueToolkit_ATTRIBUTE_UPDATE_INTERVAL_ONCE;
    public static final String UPDATE_INTERVAL_DEFAULT = Messages.AttributeValueToolkit_ATTRIBUTE_UPDATE_INTERVAL_DEFAULT;
    public static final String UPDATE_INTERVAL_CUSTOM = Messages.AttributeValueToolkit_ATTRIBUTE_UPDATE_INTERVAL_CUSTOM;
    public static final String[] POLICY_ITEMS = new String[]{UPDATE_INTERVAL_ONCE, UPDATE_INTERVAL_DEFAULT, UPDATE_INTERVAL_CUSTOM};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String[] getUpdateAlternatives() {
        return new String[]{UPDATE_INTERVAL_ONCE, UPDATE_INTERVAL_DEFAULT, UPDATE_INTERVAL_CUSTOM};
    }

    public static String getUpdatePolicyText(IConnectionHandle handle, AttributeDescriptor descriptor) {
        IUpdatePolicy policy = UpdatePolicyToolkit.getUpdatePolicy((IConnectionHandle)handle, (AttributeDescriptor)descriptor);
        if (policy instanceof DefaultUpdatePolicy) {
            return UPDATE_INTERVAL_DEFAULT;
        }
        if (policy instanceof OneShotUpdatePolicy) {
            return UPDATE_INTERVAL_ONCE;
        }
        if (policy instanceof SimpleUpdatePolicy) {
            SimpleUpdatePolicy s = (SimpleUpdatePolicy)policy;
            return Integer.toString(s.getUpdateTime());
        }
        return null;
    }

    public static boolean isEditable(Object object) {
        if (object instanceof IAttributeInfo && ((IAttributeInfo)object).isWritable()) {
            return true;
        }
        return object instanceof AttributeValueInfo && ((AttributeValueInfo)object).isEditable(new ValueEditorFactory());
    }

    public static void setAttributeValue(IConnectionHandle handle, AttributeDescriptor attributeDescriptor, Attribute attribute) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.management.MBeanServerConnection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MBeanServerConnection connection = (MBeanServerConnection)handle.getService((Class)clazz);
            connection.setAttribute(attributeDescriptor.getObjectName(), attribute);
        }
        catch (OperationsException e) {
            DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AttributeValueToolkit_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)e);
        }
        catch (MBeanException e) {
            DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AttributeValueToolkit_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)e);
        }
        catch (ReflectionException e) {
            DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AttributeValueToolkit_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)e);
        }
        catch (IOException e) {
            DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AttributeValueToolkit_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)e);
        }
    }

    public static Object getAttributeValue(IConnectionHandle handle, AttributeDescriptor descriptor) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.management.MBeanServerConnection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MBeanServerConnection connection = (MBeanServerConnection)handle.getService((Class)clazz);
            return connection.getAttribute(descriptor.getObjectName(), descriptor.getAttributeName());
        }
        catch (UnmarshalException e) {
            MBeanBrowserPlugin.getDefault().getLogger().warning(NLS.bind((String)Messages.AttributeValueToolkit_UNMARSHAL_EXCEPTION_LOG_MESSAGE, (Object)AttributeInfoToolkit.getDisplayName((IConnectionHandle)handle, (AttributeDescriptor)descriptor), (Object)e.getMessage()));
        }
        catch (MBeanException e) {
            if (descriptor.getAttributeName().endsWith("SystemProperties")) {
                MBeanBrowserPlugin.getDefault().getLogger().log(Level.SEVERE, e.getMessage(), e);
            } else {
                MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        }
        catch (OperationsException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        catch (ReflectionException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    public static List filterForNumericalAttributeDescriptors(List descriptors) {
        ArrayList<AttributeDescriptor> numericals = new ArrayList<AttributeDescriptor>();
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            IAttributeInfo info = null;
            if (object instanceof AttributeValueInfo) {
                AttributeValueInfo avi = (AttributeValueInfo)object;
                info = avi.getAttributeInfo();
            }
            if (object instanceof IAttributeInfo) {
                info = (IAttributeInfo)object;
            }
            if (!info.isNumerical()) continue;
            numericals.add(info.getAttributeDescriptor());
        }
        return numericals;
    }

    public static AttributeDescriptor extractFirstAttributeDescriptor(ISelectionProvider provider) {
        IStructuredSelection structuredSelection = (IStructuredSelection)provider.getSelection();
        if (!structuredSelection.isEmpty()) {
            return AttributeValueToolkit.extractAttributeDescriptor(structuredSelection.getFirstElement());
        }
        return null;
    }

    public static AttributeDescriptor extractAttributeDescriptor(Object object) {
        if (object instanceof IAttributeInfo) {
            return ((IAttributeInfo)object).getAttributeDescriptor();
        }
        if (object instanceof AttributeValueInfo) {
            return ((AttributeValueInfo)object).getAttributeInfo().getAttributeDescriptor();
        }
        return null;
    }

    public static void inspect(StructuredViewer viewer, AttributeValueModel holder, IConnectionHandle handle) {
        final AttributesTableInspectorContext cp = new AttributesTableInspectorContext((ISelectionProvider)viewer, handle, holder);
        final InspectorAction inspectAction = new InspectorAction(com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages.ValueEditorFactory_BUTTON_INSPECT_TEXT, com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages.ValueEditorFactory_DIALOG_INSPECT_TITLE, viewer, false, cp.getTypeToInspect(), cp.getValueToInspect());
        inspectAction.setValueChangedListener(new ValueChangedListener(){

            public void valueChanged(boolean changed) {
                if (changed) {
                    cp.setValue(inspectAction.getValue());
                }
            }
        });
        inspectAction.setEnabled(true);
        inspectAction.run();
    }

    public static void edit(StructuredViewer viewer, AttributeValueModel holder, IConnectionHandle handle) {
        final AttributesTableInspectorContext cp = new AttributesTableInspectorContext((ISelectionProvider)viewer, handle, holder);
        final InspectorAction inspectAction = new InspectorAction(com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages.ValueEditorFactory_BUTTON_EDIT_TEXT, com.jrockit.mc.console.ui.mbeanbrowser.inspect.Messages.ValueEditorFactory_DIALOG_EDIT_TITLE, viewer, true, cp.getTypeToInspect(), cp.getValueToInspect());
        inspectAction.setValueChangedListener(new ValueChangedListener(){

            public void valueChanged(boolean changed) {
                if (changed) {
                    cp.setValue(inspectAction.getValue());
                }
            }
        });
        inspectAction.setEnabled(true);
        inspectAction.run();
    }

    public static Class getClassWithName(IAttributeInfo info) {
        try {
            return TypeHandling.getClassWithName(info.getAttributeType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                }
            }
            return clazz;
        }
    }

    public static boolean isSynthetic(ObjectName objectName) {
        return AttributeValueToolkit.contains(objectName.getDomain(), "jrockit.synthetic");
    }

    private static boolean contains(String string, String pattern) {
        return string.indexOf(pattern) >= 0;
    }
}

