/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueToolkit;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.AttributeValueInfo;
import com.jrockit.mc.console.ui.mbeanbrowser.valueinfo.SingleValueInfo;
import com.jrockit.mc.core.MCConstants;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.subscription.AttributeValueEvent;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class AttributeValueModel
extends Observable {
    private final IConnectionHandle m_handle;
    private volatile InternalAttributeValueHolder attributesHolder = new InternalAttributeValueHolder(new HashMap(), new ArrayList());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AttributeValueModel(IConnectionHandle handle) {
        this.m_handle = handle;
        this.registerObserver();
    }

    private void registerObserver() {
        RJMXUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("console.ui.mbeanbrowser.aggregateSize")) {
                    AttributeValueInfo.setAggregateSize((Integer)event.getNewValue());
                    AttributeValueModel.this.setChanged();
                    AttributeValueModel.this.notifyObservers();
                }
            }
        });
    }

    public Object getValue(IAttributeInfo info) {
        return this.attributesHolder.attributeInfoValueMap.get(info);
    }

    public IConnectionHandle getConnectionHandle() {
        return this.m_handle;
    }

    public void refreshValues() {
        this.attributesHolder = this.createAttributeValueMap(this.attributesHolder.attributesToShow);
        this.setChanged();
        this.notifyObservers();
    }

    public void setAttributeValue(SingleValueInfo sInfo, Object value) {
        IAttributeInfo attributeInfo = sInfo.getAttributeInfo();
        Object attributeInfoValue = this.getValue(attributeInfo);
        sInfo.setValue(attributeInfoValue, value);
        this.setAttributeValue(attributeInfo, this.getValue(attributeInfo));
    }

    public void setAttributeValue(IAttributeInfo infoToSet, Object valueToSet) {
        if (infoToSet.getAttributeDescriptor().isCompositeChild()) {
            IAttributeInfo parentInfo = AttributeInfoToolkit.getCompositeParent((IConnectionHandle)this.getConnectionHandle(), (IAttributeInfo)infoToSet);
            CompositeData data = (CompositeData)this.attributesHolder.attributeInfoValueMap.get(parentInfo);
            CompositeType type = data.getCompositeType();
            String[] keys = type.keySet().toArray(new String[type.keySet().size()]);
            Object[] values = data.getAll(keys);
            String keyOfChangedValue = infoToSet.getAttributeDescriptor().getAttributeName().substring(infoToSet.getAttributeDescriptor().getAttributeName().lastIndexOf(AttributeToolkit.VALUE_COMPOSITE_DELIMITER) + 1);
            int i = 0;
            while (i < keys.length) {
                if (keys[i].equals(keyOfChangedValue)) {
                    values[i] = valueToSet;
                }
                ++i;
            }
            infoToSet = parentInfo;
            try {
                valueToSet = new CompositeDataSupport(data.getCompositeType(), keys, values);
            }
            catch (OpenDataException e) {
                DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AttributeValueToolkit_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)e);
                return;
            }
        }
        AttributeDescriptor attributeDescriptor = infoToSet.getAttributeDescriptor();
        Attribute attribute = new Attribute(attributeDescriptor.getAttributeName(), valueToSet);
        AttributeValueToolkit.setAttributeValue(this.m_handle, attributeDescriptor, attribute);
        this.refreshValues();
    }

    public void setObjectName(ObjectName name) {
        Map attrMap = this.getAttributeInfoService().getAvailableAttributes(name);
        this.attributesHolder = this.createAttributeValueMap(attrMap.values());
        this.setChanged();
        this.notifyObservers();
    }

    public Collection getAttributes() {
        return this.attributesHolder.attributesToShow;
    }

    private InternalAttributeValueHolder createAttributeValueMap(Collection attrInfos) {
        HashMap result = new HashMap();
        Iterator iter = attrInfos.iterator();
        while (iter.hasNext()) {
            IAttributeInfo info = (IAttributeInfo)iter.next();
            if (!info.isReadable()) continue;
            if (info.isSynthetic()) {
                this.addSyntethicAttributeValue(result, info);
                continue;
            }
            this.addNormalAttributeValue(result, info);
        }
        return new InternalAttributeValueHolder(result, attrInfos);
    }

    private void addSyntethicAttributeValue(Map map, IAttributeInfo info) {
        AttributeValueEvent last = this.getSubscriptionService().getLastAttributeValueEvent(info.getAttributeDescriptor());
        if (last != null) {
            map.put(info, this.nullSafe(last.getValue()));
        }
    }

    private void addNormalAttributeValue(Map map, IAttributeInfo info) {
        AttributeDescriptor attributeDescriptor = info.getAttributeDescriptor();
        Object attributeValue = AttributeValueToolkit.getAttributeValue(this.m_handle, attributeDescriptor);
        if (attributeValue != null && info.isComposite()) {
            IAttributeInfo[] children = AttributeInfoToolkit.getCompositeChildren((IConnectionHandle)this.getConnectionHandle(), (IAttributeInfo)info);
            int i = 0;
            while (i < children.length) {
                String childName = children[i].getAttributeDescriptor().getAttributeName().substring(attributeDescriptor.getAttributeName().length() + 1);
                map.put(children[i], ((CompositeData)attributeValue).get(childName));
                ++i;
            }
        }
        map.put(info, this.nullSafe(attributeValue));
    }

    private Object nullSafe(Object object) {
        return object == null ? MCConstants.NOT_AVAILABLE : object;
    }

    private ISubscriptionService getSubscriptionService() {
        IConnectionHandle iConnectionHandle = this.getConnectionHandle();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.subscription.ISubscriptionService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISubscriptionService)iConnectionHandle.getService((Class)clazz);
    }

    private IAttributeInfoService getAttributeInfoService() {
        IConnectionHandle iConnectionHandle = this.getConnectionHandle();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.jrockit.mc.rjmx.subscription.IAttributeInfoService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IAttributeInfoService)iConnectionHandle.getService((Class)clazz);
    }

    public String getUpdateIntervalText(AttributeDescriptor attributeDescriptor) {
        return AttributeValueToolkit.getUpdatePolicyText(this.m_handle, attributeDescriptor);
    }

    private static final class InternalAttributeValueHolder {
        private final Map attributeInfoValueMap;
        private final Collection attributesToShow;

        private InternalAttributeValueHolder(Map map, Collection attributes) {
            this.attributeInfoValueMap = map;
            this.attributesToShow = attributes;
        }
    }
}

