/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeTreeContentProvider;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueModel;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeValueToolkit;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.BoldItemFieldLabelProvider;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.editors.AttributeValueEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.editors.UpdateIntervalEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.interval.UpdateIntervalAction;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.visualize.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.visualize.VisualizeAction;
import com.jrockit.mc.console.ui.mbeanbrowser.inspect.InspectAttributeTreeAction;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeSectionPart;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.sections.FieldTreeViewerSectionPart;
import com.jrockit.mc.core.ui.MCLayoutFactory;
import com.jrockit.mc.core.ui.fields.FieldTreeEditor;
import com.jrockit.mc.core.ui.fields.IFieldEditorControlFactory;
import com.jrockit.mc.rjmx.IConnectionHandle;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.management.ObjectName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class AttributeTreeSectionPart
extends FieldTreeViewerSectionPart
implements IPartSelectionListener {
    private static Field[] FIELD_PROTOTYPES = new Field[]{AttributeTreeContentProvider.FIELD_NAME, AttributeTreeContentProvider.FIELD_VALUE, AttributeTreeContentProvider.FIELD_TYPE, AttributeTreeContentProvider.FIELD_UPDATE_INTERVAL, AttributeTreeContentProvider.FIELD_DESCRIPTION};

    public AttributeTreeSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier, FIELD_PROTOTYPES, MBeanBrowserPlugin.getDefault().getMCDialogSettings());
    }

    protected void initializeSection(Section section) {
    }

    protected void setupSelectionListeners() {
    }

    protected Composite createRightControl(Composite parent) {
        return this.createButtonContainer(parent);
    }

    private Composite createButtonContainer(Composite parent) {
        Composite container = this.getFormToolkit().createComposite(parent);
        this.createInspectButton(container).setLayoutData(this.createButtonLayoutData());
        this.createVisualizeInspectButton(container).setLayoutData(this.createButtonLayoutData());
        this.createUpdatesButton(container).setLayoutData(this.createButtonLayoutData());
        this.createSeparator(container).setLayoutData(this.createButtonLayoutData());
        this.createRefreshButton(container).setLayoutData(this.createButtonLayoutData());
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        return container;
    }

    private Label createSeparator(Composite parent) {
        return new Label(parent, 0);
    }

    private Object createButtonLayoutData() {
        return MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false);
    }

    private Button createUpdatesButton(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages.AttributeTreeSectionPart_BUTTON_UPDATES_TEXT, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new UpdateIntervalAction((StructuredViewer)AttributeTreeSectionPart.this.getViewer(), AttributeTreeSectionPart.this.getConnectionHandle()).run();
            }
        });
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                button.setEnabled(AttributeTreeSectionPart.this.getSelectedAttributeDescriptors().size() == 1);
            }
        });
        button.setEnabled(false);
        return button;
    }

    private Button createVisualizeInspectButton(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, Messages.VisualizeAction_VISUALIZE_ATTRIBUTE_TEXT, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new VisualizeAction(AttributeTreeSectionPart.this.getConsoleEditor(), (StructuredViewer)AttributeTreeSectionPart.this.getViewer()).run();
            }
        });
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                button.setEnabled(!AttributeValueToolkit.filterForNumericalAttributeDescriptors(AttributeTreeSectionPart.this.getSelectedAttributeDescriptors()).isEmpty());
            }
        });
        return button;
    }

    private Button createRefreshButton(Composite parent) {
        Button button = this.getFormToolkit().createButton(parent, com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages.AttributeTreeSectionPart_REFRESH_ACTION_TEXT, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeTreeSectionPart.this.getModel().refreshValues();
            }
        });
        return button;
    }

    private Button createInspectButton(Composite parent) {
        final Button button = this.getFormToolkit().createButton(parent, com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages.AttributeTreeSectionPart_BUTTON_INSPECT_TEXT, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AttributeValueToolkit.isEditable(((IStructuredSelection)AttributeTreeSectionPart.this.getViewer().getSelection()).getFirstElement())) {
                    AttributeValueToolkit.edit((StructuredViewer)AttributeTreeSectionPart.this.getTreeViewer(), AttributeTreeSectionPart.this.getModel(), AttributeTreeSectionPart.this.getConnectionHandle());
                } else {
                    AttributeValueToolkit.inspect((StructuredViewer)AttributeTreeSectionPart.this.getTreeViewer(), AttributeTreeSectionPart.this.getModel(), AttributeTreeSectionPart.this.getConnectionHandle());
                }
            }
        });
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                button.setEnabled(!event.getSelection().isEmpty());
            }
        });
        return button;
    }

    public void initializePart() {
        super.initializePart();
        AttributeValueModel model = this.createModel();
        this.setupViewer(model);
        this.setupFieldEditor(model);
        this.setupMenuManager(model);
    }

    protected AttributeValueModel createModel() {
        return new AttributeValueModel(this.getConnectionHandle());
    }

    protected void setupViewer(AttributeValueModel model) {
        this.getTreeViewer().setContentProvider((IContentProvider)new AttributeTreeContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new BoldItemFieldLabelProvider(this.getFields()));
        this.getTreeViewer().setInput((Object)model);
        this.getTreeViewer().getTree().setData("name", (Object)"mbeanbrowser.AttributesTab.AttributesTree");
        this.setSortColumn(AttributeTreeContentProvider.FIELD_NAME, true);
        this.getModel().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                AttributeTreeSectionPart.this.refreshViewer();
            }
        });
    }

    protected void setupMenuManager(AttributeValueModel model) {
        this.getMenuManager().add((IAction)new VisualizeAction(this.getConsoleEditor(), (StructuredViewer)this.getViewer()));
        this.getMenuManager().add((IAction)new InspectAttributeTreeAction((StructuredViewer)this.getViewer(), this.getConnectionHandle(), model));
    }

    protected void setupFieldEditor(AttributeValueModel model) {
        FieldTreeEditor editor = new FieldTreeEditor(this.getTreeViewer());
        editor.addEditableField(AttributeTreeContentProvider.FIELD_UPDATE_INTERVAL, (IFieldEditorControlFactory)new UpdateIntervalEditor(this.getConnectionHandle()));
        editor.addEditableField(AttributeTreeContentProvider.FIELD_VALUE, (IFieldEditorControlFactory)new AttributeValueEditor(editor, model));
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection str;
        if (part instanceof MBeanTreeSectionPart && !selection.isEmpty() && (str = (IStructuredSelection)selection).getFirstElement() instanceof ObjectName) {
            this.getModel().setObjectName((ObjectName)str.getFirstElement());
        }
    }

    protected void refreshViewer() {
        DisplayToolkit.safeAsyncExec((Widget)this.getSection(), (Runnable)new Runnable(){

            public void run() {
                AttributeTreeSectionPart.this.getTreeViewer().refresh();
            }
        });
    }

    protected final ConsoleEditor getConsoleEditor() {
        return (ConsoleEditor)((IFormPage)this.getManagedForm().getContainer()).getEditor();
    }

    protected final IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }

    protected final AttributeValueModel getModel() {
        return (AttributeValueModel)this.getViewer().getInput();
    }

    protected final List getSelectedAttributeDescriptors() {
        return ((IStructuredSelection)this.getViewer().getSelection()).toList();
    }
}

