/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser;

import com.jrockit.mc.console.ui.mbeanbrowser.Messages;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.osgi.util.NLS;

public final class TypeHandling {
    private static final HashMap formalPrimitiveMap = new HashMap();
    private static final String VALUE_COMPOSITE_DATA = "CompositeData";
    private static final String VALUE_TABULAR_DATA = "TabularData";
    private static HashMap primitiveMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;

    static {
        formalPrimitiveMap.put("B", "byte");
        formalPrimitiveMap.put("C", "char");
        formalPrimitiveMap.put("D", "double");
        formalPrimitiveMap.put("F", "float");
        formalPrimitiveMap.put("I", "int");
        formalPrimitiveMap.put("J", "long");
        formalPrimitiveMap.put("S", "short");
        formalPrimitiveMap.put("Z", "boolean");
        primitiveMap = new HashMap();
        String string = Integer.TYPE.getName();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveMap.put(string, clazz);
        String string2 = Long.TYPE.getName();
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveMap.put(string2, clazz2);
        String string3 = Short.TYPE.getName();
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveMap.put(string3, clazz3);
        String string4 = Character.TYPE.getName();
        Class<?> clazz4 = class$7;
        if (clazz4 == null) {
            try {
                clazz4 = class$7 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveMap.put(string4, clazz4);
        String string5 = Byte.TYPE.getName();
        Class<?> clazz5 = class$9;
        if (clazz5 == null) {
            try {
                clazz5 = class$9 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveMap.put(string5, clazz5);
        String string6 = Float.TYPE.getName();
        Class<?> clazz6 = class$11;
        if (clazz6 == null) {
            try {
                clazz6 = class$11 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveMap.put(string6, clazz6);
        String string7 = Double.TYPE.getName();
        Class<?> clazz7 = class$13;
        if (clazz7 == null) {
            try {
                clazz7 = class$13 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveMap.put(string7, clazz7);
        String string8 = Boolean.TYPE.getName();
        Class<?> clazz8 = class$15;
        if (clazz8 == null) {
            try {
                clazz8 = class$15 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveMap.put(string8, clazz8);
    }

    private TypeHandling() {
    }

    public static String simplifyType(String typeName) {
        Class<?> clazz;
        String arrayString = "";
        while (typeName.startsWith("[")) {
            typeName = typeName.substring(1);
            arrayString = String.valueOf(arrayString) + "[]";
        }
        if (typeName.endsWith(";")) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        if ((clazz = class$16) == null) {
            try {
                clazz = class$16 = Class.forName("javax.management.openmbean.CompositeData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (typeName.equals(clazz.getName())) {
            typeName = VALUE_COMPOSITE_DATA;
        } else {
            Class<?> clazz2 = class$17;
            if (clazz2 == null) {
                try {
                    clazz2 = class$17 = Class.forName("javax.management.openmbean.TabularData");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (typeName.equals(clazz2.getName())) {
                typeName = VALUE_TABULAR_DATA;
            } else {
                Class<?> clazz3 = class$18;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$18 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (typeName.equals(clazz3.getName())) {
                    typeName = "String";
                } else if (formalPrimitiveMap.containsKey(typeName)) {
                    typeName = (String)formalPrimitiveMap.get(typeName);
                }
            }
        }
        return String.valueOf(typeName) + arrayString;
    }

    public static String getPrimitiveTypeName(Object value) {
        if (value instanceof Boolean) {
            return Boolean.TYPE.getName();
        }
        if (value instanceof Character) {
            return Character.TYPE.getName();
        }
        if (value instanceof Byte) {
            return Byte.TYPE.getName();
        }
        if (value instanceof Short) {
            return Short.TYPE.getName();
        }
        if (value instanceof Integer) {
            return Integer.TYPE.getName();
        }
        if (value instanceof Long) {
            return Long.TYPE.getName();
        }
        if (value instanceof Float) {
            return Float.TYPE.getName();
        }
        if (value instanceof Double) {
            return Double.TYPE.getName();
        }
        return null;
    }

    public static String buildParameterString(MBeanParameterInfo[] params) {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        int p = 0;
        while (p < params.length) {
            if (p != 0) {
                buf.append(", ");
            }
            buf.append(TypeHandling.simplifyType(params[p].getType()));
            buf.append(' ');
            buf.append(params[p].getName());
            ++p;
        }
        buf.append(')');
        return buf.toString();
    }

    private static String createSizeString(String typeName, int size) {
        return NLS.bind((String)Messages.TypeHandling_VALUE_SIZE_TEXT, (Object)typeName, (Object)new Integer(size));
    }

    public static String getValueString(Object value) {
        if (value != null) {
            if (value instanceof CompositeData) {
                return TypeHandling.createSizeString(VALUE_COMPOSITE_DATA, ((CompositeData)value).values().size());
            }
            if (value instanceof TabularData) {
                return TypeHandling.createSizeString(VALUE_TABULAR_DATA, ((TabularData)value).size());
            }
            if (value.getClass().isArray()) {
                String typeString = TypeHandling.simplifyType(value.getClass().getName());
                int firstBracketIndex = typeString.indexOf("[");
                return String.valueOf(typeString.substring(0, firstBracketIndex + 1)) + Array.getLength(value) + typeString.substring(firstBracketIndex + 1);
            }
            if (value instanceof Collection) {
                return TypeHandling.createSizeString(value.getClass().getName(), ((Collection)value).size());
            }
            if (value instanceof Map) {
                return TypeHandling.createSizeString(value.getClass().getName(), ((Map)value).size());
            }
            return value.toString();
        }
        return String.valueOf(null);
    }

    public static Class getClassWithName(String name) throws ClassNotFoundException {
        Class c = (Class)primitiveMap.get(name);
        if (c == null) {
            return Class.forName(name);
        }
        return c;
    }
}

