/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.jdp.preferences;

import com.jrockit.mc.browser.jdp.JDPDescriptorProvider;
import com.jrockit.mc.browser.jdp.JDPPlugin;
import com.jrockit.mc.browser.jdp.preferences.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JDPPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text m_adress;
    private Text m_port;

    public JDPPreferencePage() {
        this.setPreferenceStore(JDPPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.JDPPreferencePage_JDP_PREFERENCES_DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gridData1 = new GridData(4, 1, false, false);
        Label groupLabel = new Label(container, 0);
        groupLabel.setText(Messages.JDPPreferencePage_CAPTION_MULTICAST_ADDRESS);
        groupLabel.setLayoutData((Object)gridData1);
        GridData gridData2 = new GridData(4, 1, true, false);
        this.m_adress = new Text(container, 2048);
        String adress = System.getProperty("com.jrockit.console.preferences.jdp.address");
        if (adress != null) {
            this.m_adress.setText(adress);
        }
        this.m_adress.setLayoutData((Object)gridData2);
        GridData gridData3 = new GridData(4, 1, false, false);
        Label portLabel = new Label(container, 0);
        portLabel.setText(Messages.JDPPreferencePage_CAPTION_MULTICAST_PORT);
        portLabel.setLayoutData((Object)gridData3);
        GridData gridData4 = new GridData(4, 1, true, false);
        this.m_port = new Text(container, 2048);
        String port = System.getProperty("com.jrockit.console.preferences.jdp.port");
        if (port != null) {
            this.m_port.setText(port);
        }
        this.m_port.setLayoutData((Object)gridData4);
        GridData gridData5 = new GridData(4, 1, true, false);
        gridData5.horizontalSpan = 2;
        Composite note = this.createNoteComposite(this.getFont(), container, Messages.JDPPreferencePage_NOTE, Messages.JDPPreferencePage_NEED_RESTART_MESSAGE);
        note.setLayoutData((Object)gridData5);
        GridData gridData6 = new GridData(0x1000000, 128, true, true);
        gridData6.horizontalSpan = 2;
        Button resetCache = new Button(container, 8);
        resetCache.setText(Messages.JDPPreferencePage_BUTTON_RESET_JDP_CACHE_TEXT);
        resetCache.setToolTipText(Messages.JDPPreferencePage_BUTTON_RESET_JDP_CACHE_TOOLTIP);
        resetCache.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JDPDescriptorProvider.resetDescriptorCache();
            }
        });
        resetCache.setLayoutData((Object)gridData6);
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        String defaultAdress = "232.192.1.212";
        System.setProperty("com.jrockit.console.preferences.jdp.address", "232.192.1.212");
        this.m_adress.setText(defaultAdress);
        String defaultPort = "7095";
        System.setProperty("com.jrockit.console.preferences.jdp.address", "232.192.1.212");
        this.m_port.setText(defaultPort);
        this.updateApplyButton();
    }

    public boolean performOk() {
        String adress = this.m_adress.getText();
        System.setProperty("com.jrockit.console.preferences.jdp.address", adress);
        String port = this.m_port.getText();
        System.setProperty("com.jrockit.console.preferences.jdp.port", port);
        return true;
    }
}

