/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.jdp;

import com.jrockit.common.jdp.ClientJDPPacket;
import com.jrockit.console.jdp.DiscoveryHandler;
import com.jrockit.console.jdp.JDPClient;
import com.jrockit.mc.browser.JRockitBrowserPlugin;
import com.jrockit.mc.browser.autodiscovery.AbstractDescriptorProvider;
import com.jrockit.mc.browser.autodiscovery.IDescriptorListener;
import com.jrockit.mc.browser.jdp.Messages;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.JMXDescriptorBuilder;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.JMXConnectionDescriptor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;

public class JDPDescriptorProvider
extends AbstractDescriptorProvider {
    private static long PRUNING_INTERVAL = 10000L;
    private static long MAX_HB_TIME = 0x6DDD00L;
    private static Map descriptorCache = new WeakHashMap();
    private DescriptorPruner m_pruner = new DescriptorPruner();
    private JDPDiscoveryHandler m_discoveryHandler = new JDPDiscoveryHandler();
    private Thread m_prunerThread;
    static /* synthetic */ Class class$0;

    public String getName() {
        return Messages.JDPDescriptorProvider_PROVIDER_NAME;
    }

    private void initialize() {
        this.m_discoveryHandler.isRunning = true;
        this.getJDPClient().addDiscoveryHandler((DiscoveryHandler)this.m_discoveryHandler);
        Thread t = new Thread((Runnable)this.m_pruner, "JDP Stale Descriptor Detector");
        t.start();
    }

    private JDPClient getJDPClient() {
        RJMXPlugin rJMXPlugin = RJMXPlugin.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.console.jdp.JDPClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (JDPClient)rJMXPlugin.getService((Class)clazz);
    }

    public void removeDescriptorListener(IDescriptorListener l) {
        super.removeDescriptorListener(l);
        if (this.m_descriptorListeners.size() == 0) {
            this.m_discoveryHandler.shutDown();
            this.m_pruner.shutDown();
            if (this.m_prunerThread != null) {
                this.m_prunerThread.interrupt();
            }
            this.getJDPClient().removeDiscoveryHandler((DiscoveryHandler)this.m_discoveryHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            if (this.m_descriptorListeners.size() == 0) {
                super.addDescriptorListener(l);
                this.initialize();
                return;
            }
            super.addDescriptorListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDescriptorCache() {
        Map map = descriptorCache;
        synchronized (map) {
            descriptorCache.clear();
        }
    }

    private static class DescriptorInfo {
        long timeLastDiscoveryTime;
        long timeHBInterval;

        private DescriptorInfo() {
        }
    }

    private class DescriptorPruner
    implements Runnable {
        boolean isRunning;

        private DescriptorPruner() {
        }

        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                this.checkDescriptorCache();
                try {
                    Thread.sleep(PRUNING_INTERVAL);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkDescriptorCache() {
            long now = System.currentTimeMillis();
            Map map = descriptorCache;
            synchronized (map) {
                Iterator iter = descriptorCache.keySet().iterator();
                while (iter.hasNext()) {
                    IConnectionDescriptor key = (IConnectionDescriptor)iter.next();
                    DescriptorInfo info = (DescriptorInfo)descriptorCache.get(key);
                    if (info.timeHBInterval != 0L) {
                        if (!((double)(now - info.timeLastDiscoveryTime) > (double)info.timeHBInterval * 3.5)) continue;
                        this.remove(key, iter);
                        continue;
                    }
                    if (now - info.timeLastDiscoveryTime <= MAX_HB_TIME) continue;
                    this.remove(key, iter);
                }
            }
        }

        private void remove(IConnectionDescriptor key, Iterator iter) {
            iter.remove();
            JDPDescriptorProvider.this.fireDescriptorChange(key, IDescriptorListener.EventType.DESCRIPTOR_REMOVE);
        }

        public void shutDown() {
            this.isRunning = false;
        }
    }

    private class JDPDiscoveryHandler
    implements DiscoveryHandler {
        boolean isRunning = true;

        private JDPDiscoveryHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDiscovery(ClientJDPPacket packet) {
            if (!this.isRunning) {
                return;
            }
            Map map = descriptorCache;
            synchronized (map) {
                this.doDiscovery(packet);
            }
        }

        private void doDiscovery(ClientJDPPacket packet) {
            boolean useJMXRMI;
            IConnectionDescriptor descriptor = null;
            try {
                useJMXRMI = packet.supportsJMX();
            }
            catch (Exception nae) {
                useJMXRMI = JMXConnectionDescriptor.SUPPORTS_JMXRMI;
            }
            try {
                descriptor = new JMXDescriptorBuilder().hostName(packet.getAddress()).port(packet.getPort()).useRMP(!useJMXRMI).name(packet.getName()).build();
                descriptor.getExtendedProperties().put("com.jrockit.connectioninfo.jdp.discovered", Boolean.TRUE);
            }
            catch (IllegalStateException e) {
                JRockitBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Could not create node from JDP packet.", e);
                return;
            }
            DescriptorInfo info = (DescriptorInfo)descriptorCache.get(descriptor);
            long now = System.currentTimeMillis();
            if (info == null) {
                info = new DescriptorInfo();
                info.timeLastDiscoveryTime = now;
                descriptorCache.put(descriptor, info);
                IConnectionDescriptor descriptorToReport = descriptor;
                Thread descriptorDeliveryThread = new Thread(new Runnable(this, descriptorToReport){
                    final /* synthetic */ JDPDiscoveryHandler this$1;
                    private final /* synthetic */ IConnectionDescriptor val$descriptorToReport;
                    {
                        this.this$1 = jDPDiscoveryHandler;
                        this.val$descriptorToReport = iConnectionDescriptor;
                    }

                    public void run() {
                        this.val$descriptorToReport.getName();
                        JDPDescriptorProvider.access$3(JDPDiscoveryHandler.access$1(this.this$1), this.val$descriptorToReport, IDescriptorListener.EventType.DESCRIPTOR_ADD);
                    }
                }, "Discovery of " + packet.getAddress());
                descriptorDeliveryThread.start();
                return;
            }
            long newHBInterval = now - info.timeLastDiscoveryTime;
            info.timeHBInterval = info.timeHBInterval == 0L ? newHBInterval : (info.timeHBInterval + newHBInterval) / 2L;
            info.timeLastDiscoveryTime = now;
        }

        public void shutDown() {
            this.isRunning = false;
        }

        static /* synthetic */ JDPDescriptorProvider access$1(JDPDiscoveryHandler jDPDiscoveryHandler) {
            return jDPDiscoveryHandler.JDPDescriptorProvider.this;
        }
    }
}

