/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.mc.common.porting.JDK14Util;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.profiler.common.AbstractTemplate;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.method.Clazz;
import com.jrockit.mc.console.ui.profiler.method.Messages;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Template
extends AbstractTemplate
implements XmlEnabled,
Cloneable {
    Map m_classes = Collections.synchronizedMap(new HashMap());

    public Template(String name) {
        super(name);
    }

    public Template() {
        super(Messages.Template_DEFAULT_TEMPLATE);
    }

    public void add(Clazz clazz) {
        this.m_classes.put(clazz.getClassName(), clazz);
    }

    public Clazz createClass(String className) {
        Clazz clazz = (Clazz)this.m_classes.get(className);
        if (clazz == null) {
            clazz = new Clazz(className);
            this.m_classes.put(className, clazz);
        }
        return clazz;
    }

    public Collection getAllClasses() {
        return this.m_classes.values();
    }

    public void removeClass(Clazz clazz) {
        this.m_classes.remove(clazz.getClassName());
    }

    public void initializeFromXml(Element node) {
        String value = XmlToolkit.getSetting((Element)node, (String)"enabled", null);
        if (value != null) {
            this.setEnabled(JDK14Util.parseBoolean((String)value));
        }
        this.setName(XmlToolkit.getSetting((Element)node, (String)"name", (String)"unknown"));
        NodeList classList = node.getElementsByTagName("class");
        if (classList != null) {
            int i = 0;
            while (i < classList.getLength()) {
                if (TemplateContainer.isGlobal(node)) {
                    Clazz clazz = new Clazz("");
                    clazz.initializeFromXml((Element)classList.item(i));
                    this.add(clazz);
                } else {
                    Clazz prototype = new Clazz("");
                    prototype.initializeFromXml((Element)classList.item(i));
                    Clazz actual = this.getClazz(prototype.getClassName());
                    if (actual != null) {
                        actual.initializeFromXml((Element)classList.item(i));
                    }
                }
                ++i;
            }
        }
    }

    public void exportToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)"enabled", (String)Boolean.toString(this.getEnabled()));
        XmlToolkit.setSetting((Element)node, (String)"name", (String)this.getName());
        Iterator iter = this.m_classes.values().iterator();
        while (iter.hasNext()) {
            Element clazzElement = XmlToolkit.createElement((Element)node, (String)"class");
            ((Clazz)iter.next()).exportToXml(clazzElement);
        }
    }

    public Object clone() {
        return new Template();
    }

    public String getComponentTag() {
        return null;
    }

    public Clazz getClazz(String className) {
        return (Clazz)this.m_classes.get(className);
    }
}

