/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.mc.console.ui.profiler.ProfilerPlugin;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.method.Messages;
import com.jrockit.mc.console.ui.profiler.method.MethodProfiler;
import com.jrockit.mc.console.ui.profiler.method.MethodProfilerProvider;
import com.jrockit.mc.console.ui.profiler.method.ProfilingLabelProvider;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.sections.FieldTableViewerSectionPart;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.core.ui.fields.FieldLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ProfilingPart
extends FieldTableViewerSectionPart
implements NotificationSystem.ModelListener,
DisposeListener {
    private static final Field[] FIELD_PROTOTYPES = new Field[]{MethodProfilerProvider.FIELD_METHOD, MethodProfilerProvider.FIELD_METHOD_INVOCATIONS, MethodProfilerProvider.FIELD_METHOD_TIMING, MethodProfilerProvider.FIELD_METHOD_TIME_PER_INVOCATION, MethodProfilerProvider.FIELD_METHOD_INVOCATION_NOT_AVAILABLE, MethodProfilerProvider.FIELD_METHOD_TIMING_NOT_AVAILABLE};
    final NotificationSystem m_notificationSystem;
    final MethodProfiler m_profiler;

    public ProfilingPart(Composite parent, FormToolkit toolkit, MethodProfiler profiler, NotificationSystem notificationSystem) {
        super(parent, toolkit, MCSectionPart.getAccessibilityDescriptionStyle(), "method.profiler.information", FIELD_PROTOTYPES, ProfilerPlugin.getDefault().getMCDialogSettings());
        this.getSection().addDisposeListener((DisposeListener)this);
        this.m_notificationSystem = notificationSystem;
        this.m_profiler = profiler;
        notificationSystem.addListener(this);
    }

    protected void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new MethodProfilerProvider());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new FieldLabelProvider(this.getFields(), (IBaseLabelProvider)new ProfilingLabelProvider()));
        this.getTableViewer().setInput((Object)this.m_profiler);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.ProfilingPart_SECTION_TEXT);
        if (CorePlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    protected void setupSelectionListeners() {
    }

    protected Composite createTopControl(Composite container) {
        return null;
    }

    public void onEvent(String event, Object eventData) {
        if ("Template model has changed".equals(event) || "Available templates changed".equals(event) || "Method model has changed".equals(event) || "Refresh data".equals(event) || "New profiling data is available".equals(event)) {
            this.getTableViewer().refresh();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.m_notificationSystem.removeListener(this);
    }
}

