/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.mc.console.ui.misc.ClassProxy;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.method.Clazz;
import com.jrockit.mc.console.ui.profiler.method.Messages;
import com.jrockit.mc.console.ui.profiler.method.Method;
import com.jrockit.mc.console.ui.profiler.method.MethodContentProvider;
import com.jrockit.mc.console.ui.profiler.method.MethodLabelProvider;
import com.jrockit.mc.console.ui.profiler.method.ProfiledClassDialog;
import com.jrockit.mc.console.ui.profiler.method.Template;
import com.jrockit.mc.core.sections.ViewerSectionPart;
import com.jrockit.mc.core.ui.HelpSupport;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MethodsPart
extends ViewerSectionPart
implements IPartSelectionListener,
NotificationSystem.ModelListener,
DisposeListener {
    private static final String SECTION_NO_TEMPLATE_SELECTED_DESCRIPTION = "";
    private final NotificationSystem m_notificationSystem;
    private Button addButton;
    private Button deleteButton;
    static /* synthetic */ Class class$0;

    public MethodsPart(Composite parent, FormToolkit toolkit, NotificationSystem notificationSystem) {
        super(parent, toolkit, 384, "method.tempate");
        this.m_notificationSystem = notificationSystem;
    }

    protected void initializeSection(Section section) {
        section.setExpanded(true);
        section.setToggleColor(this.getFormToolkit().getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
    }

    protected void initializePart() {
        super.initializePart();
        this.getCheckboxTreeViewer().setContentProvider((IContentProvider)new MethodContentProvider());
        this.getCheckboxTreeViewer().setLabelProvider((IBaseLabelProvider)new MethodLabelProvider());
        this.getCheckboxTreeViewer().setUseHashlookup(true);
        this.getCheckboxTreeViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object object = event.getElement();
                boolean enabled = event.getChecked();
                if (object instanceof Clazz) {
                    Clazz clazz = (Clazz)object;
                    MethodsPart.this.setClassEnabled(clazz, enabled);
                    MethodsPart.this.m_notificationSystem.sendEvent("Method model has changed", clazz);
                }
                if (object instanceof Method) {
                    Method method = (Method)object;
                    MethodsPart.this.setMethodEnabled(method, enabled);
                    MethodsPart.this.m_notificationSystem.sendEvent("Method model has changed", method.getParentClass());
                }
            }
        });
        this.getCheckboxTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MethodsPart.this.deleteButton.setEnabled(MethodsPart.this.getSelectedClazz() != null);
            }
        });
        this.getCheckboxTreeViewer().addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
        this.getCheckboxTreeViewer().setSorter(new ViewerSorter());
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.m_notificationSystem.addListener(this);
        this.getSection().addDisposeListener((DisposeListener)this);
    }

    protected Composite createViewerClient(IManagedForm form, FormToolkit toolkit, Composite parent) {
        Composite client = toolkit.createComposite(parent, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gd = null;
        gd = new GridData(1810);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = 120;
        gd.minimumHeight = 50;
        this.m_viewer = this.createViewer(client);
        this.m_viewer.getControl().setLayoutData((Object)gd);
        gd = new GridData(2);
        Composite buttonContainer = this.createButtons(toolkit, client);
        buttonContainer.setLayoutData((Object)gd);
        Action jraHelpAction = HelpSupport.getHelpAction((String)"com.jrockit.mc.jra.ui.methods.MethodsTab");
        if (jraHelpAction != null) {
            this.addJRAAction(toolkit, client, jraHelpAction);
        }
        return client;
    }

    private void addJRAAction(FormToolkit toolkit, Composite client, final Action jraHelpAction) {
        GridData gd2 = new GridData(4, 4, true, false);
        gd2.horizontalSpan = 2;
        FormText t = toolkit.createFormText(client, true);
        t.setText(Messages.MethodsPart_JRA_TIP_TEXT, true, true);
        t.setLayoutData((Object)gd2);
        t.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                jraHelpAction.run();
            }
        });
    }

    CheckboxTreeViewer getCheckboxTreeViewer() {
        return (CheckboxTreeViewer)this.getViewer();
    }

    public Viewer getViewer() {
        return this.m_viewer;
    }

    protected Viewer createViewer(Composite parent) {
        int style = 0x800022;
        Tree tree = this.getFormToolkit().createTree(parent, style);
        CheckboxTreeViewer treeViewer = new CheckboxTreeViewer(tree);
        return treeViewer;
    }

    protected void setMethodEnabled(Method method, boolean enabled) {
        if (enabled != method.getEnabled()) {
            method.setEnabled(enabled);
        }
    }

    void setClassEnabled(Clazz clazz, boolean enabled) {
        Iterator it = clazz.getAllMethods().iterator();
        while (it.hasNext()) {
            this.setMethodEnabled((Method)it.next(), enabled);
        }
    }

    public void refreshTemplateChecked(Template template) {
        if (template != null) {
            Iterator classIterator = template.getAllClasses().iterator();
            while (classIterator.hasNext()) {
                this.refreshClassCheck((Clazz)classIterator.next());
            }
        }
    }

    void refreshClassCheck(Clazz clazz) {
        int totalMethodCount = clazz.getAllMethods().size();
        if (totalMethodCount == 0) {
            return;
        }
        int enabledCount = 0;
        Iterator it = clazz.getAllMethods().iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            this.refreshMethodCheck(method);
            if (!method.getEnabled()) continue;
            ++enabledCount;
        }
        this.getCheckboxTreeViewer().setGrayed((Object)clazz, enabledCount < totalMethodCount && enabledCount != 0);
        this.getCheckboxTreeViewer().setChecked((Object)clazz, enabledCount > 0);
    }

    void refreshMethodCheck(Method method) {
        this.getCheckboxTreeViewer().setChecked((Object)method, method.getEnabled());
    }

    private Composite createButtons(FormToolkit toolkit, Composite client) {
        Composite buttonContainer = toolkit.createComposite(client, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.createAddButton(toolkit, buttonContainer);
        this.createDeleteButton(toolkit, buttonContainer);
        return buttonContainer;
    }

    private void createAddButton(FormToolkit toolkit, Composite buttonContainer) {
        GridData gd = new GridData(4, 1, true, false);
        this.addButton = toolkit.createButton(buttonContainer, Messages.MethodsPart_BUTTON_ADD_TEXT, 8);
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodsPart.this.onAdd();
            }
        });
    }

    private void createDeleteButton(FormToolkit toolkit, Composite buttonContainer) {
        this.deleteButton = toolkit.createButton(buttonContainer, Messages.MethodsPart_BUTTON_DELETE_TEXT, 8);
        GridData gd = new GridData(4, 1, true, false);
        this.deleteButton.setLayoutData((Object)gd);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodsPart.this.onDelete();
            }
        });
    }

    protected void onAdd() {
        Object o = this.getCheckboxTreeViewer().getInput();
        if (o instanceof Template) {
            Template template = (Template)o;
            Clazz clazz = null;
            String suggestClassName = null;
            while (true) {
                ProfiledClassDialog pmd = new ProfiledClassDialog(Display.getCurrent().getActiveShell());
                if (suggestClassName != null) {
                    pmd.setSuggestClassName(suggestClassName);
                }
                if (pmd.open() != 0) {
                    return;
                }
                try {
                    suggestClassName = pmd.getClassName();
                    ClassProxy proxy = ClassProxy.forName((String)suggestClassName, (IMBeanService)this.getMBeanService());
                    MethodIdentifier[] mets = proxy.getMethodIdentifiers();
                    int n = 0;
                    while (n < mets.length) {
                        clazz = template.createClass(mets[n].getClassName());
                        Method m = new Method(clazz, mets[n]);
                        clazz.add(m);
                        template.add(m.getParentClass());
                        ++n;
                    }
                }
                catch (Exception e) {
                    String title = Messages.MethodsPart_DIALOG_CAN_NOT_FIND_CLASS_TITLE;
                    String description = NLS.bind((String)Messages.MethodsPart_DIALOG_CAN_NOT_FIND_CLASS_DESCRIPTION, (Object)pmd.getClassName());
                    DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)description, (Throwable)e);
                    continue;
                }
                break;
            }
            if (clazz != null) {
                this.m_notificationSystem.sendEvent("Method model has changed");
            }
        }
    }

    protected void onDelete() {
        Object o = this.getCheckboxTreeViewer().getInput();
        if (o instanceof Template) {
            boolean dirty = false;
            Template template = (Template)o;
            IStructuredSelection s = (IStructuredSelection)this.getCheckboxTreeViewer().getSelection();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (object instanceof Clazz) {
                    template.removeClass((Clazz)object);
                    dirty = true;
                }
                if (!(object instanceof Method)) continue;
                Method method = (Method)object;
                method.getParentClass().removeMethod(method);
                dirty = true;
            }
            if (dirty) {
                this.m_notificationSystem.sendEvent("Method model has changed");
            }
        }
    }

    public void selectClazz(Clazz clazz) {
        if (clazz != null) {
            StructuredSelection s = new StructuredSelection(new Object[]{clazz});
            this.getCheckboxTreeViewer().setSelection((ISelection)s, true);
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() >= 1) {
            Object o = ssel.getFirstElement();
            if (o != this.getCheckboxTreeViewer().getInput()) {
                this.getCheckboxTreeViewer().setInput(o);
            }
            this.refresh();
        } else {
            this.getCheckboxTreeViewer().setInput(null);
            this.refresh();
        }
    }

    public Clazz getSelectedClazz() {
        IStructuredSelection s = (IStructuredSelection)this.getCheckboxTreeViewer().getSelection();
        Object o = s.getFirstElement();
        return o instanceof Clazz ? (Clazz)o : null;
    }

    public void refreshPart() {
        this.getCheckboxTreeViewer().refresh();
        this.refreshSection();
        this.getForm().reflow(true);
    }

    private void refreshSection() {
        Template template = (Template)this.getCheckboxTreeViewer().getInput();
        this.addButton.setEnabled(template != null);
        this.deleteButton.setEnabled(this.getSelectedClazz() != null);
        if (template == null) {
            this.getSection().setText(Messages.MethodsPart_SECTION_NO_TEMPLATE_SELECTED_TEXT);
            this.getSection().setDescription(SECTION_NO_TEMPLATE_SELECTED_DESCRIPTION);
            this.getSection().layout();
            this.getSection().redraw();
        } else {
            this.getSection().setText(template.getName());
            this.getSection().setDescription(Messages.MethodsPart_SECTION_TEMPLATE_DESCRIPTION);
            this.getSection().layout();
            this.getSection().redraw();
            this.refreshTemplateChecked(template);
        }
    }

    public void setEnable(boolean enabled) {
        this.deleteButton.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.getSection().setEnabled(enabled);
        this.getSection().update();
    }

    public void onEvent(String event, Object eventData) {
        if (event.equals("Profiling has now stopped")) {
            this.setEnable(true);
        }
        if (event.equals("Profiling has now started")) {
            this.setEnable(false);
        }
        if ("Template model has changed".equals(event)) {
            this.refreshSection();
        }
        if (event.equals("Method model has changed")) {
            if (eventData instanceof Clazz) {
                this.refreshClassCheck((Clazz)eventData);
            } else {
                this.refresh();
            }
        }
    }

    private IMBeanService getMBeanService() {
        IConnectionHandle iConnectionHandle = this.getConnectionHandle();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.core.IMBeanService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMBeanService)iConnectionHandle.getService((Class)clazz);
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getInput();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.m_notificationSystem.removeListener(this);
    }
}

