/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.ConsoleEditorInput;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.ProfileMonitor;
import com.jrockit.mc.console.ui.profiler.method.Messages;
import com.jrockit.mc.console.ui.profiler.method.MethodProfilerModel;
import com.jrockit.mc.console.ui.profiler.method.MethodSashSection;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.UnmarshalException;
import java.util.logging.Level;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;

public class MethodTab
extends ConsoleTab {
    private MethodProfilerModel m_profilerModel;
    private boolean m_initialized;
    private ProfileMonitor profileMonitor;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.profileMonitor = new ProfileMonitor(this.getModel().getNotificationSystem(), this.getModel().getProfiler());
        try {
            this.doLoad();
        }
        catch (UnmarshalException e) {
            this.disableForm(managedForm);
            return;
        }
        catch (UndeclaredThrowableException e) {
            if (e.getCause() instanceof UnsupportedClassVersionError) {
                this.disableForm(managedForm);
                return;
            }
            throw e;
        }
        MethodSashSection mss = new MethodSashSection(managedForm.getForm().getBody(), managedForm.getToolkit(), "method.sash", this.m_profilerModel);
        managedForm.addPart((IFormPart)mss);
    }

    private void disableForm(IManagedForm managedForm) {
        managedForm.getForm().getBody().setLayout((Layout)new FillLayout());
        managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), Messages.MethodTab_MESSAGE_METHOD_PROFILER_NOT_SUPPORTED, 72);
    }

    public void dispose() {
        super.dispose();
        if (this.isInitialized() && this.profileMonitor != null) {
            this.profileMonitor.shutDown();
        }
        this.doSave();
    }

    public void doSave() {
        if (!this.isInitialized()) {
            return;
        }
        try {
            ConsoleEditorInput cmei = (ConsoleEditorInput)this.getEditorInput();
            String g = this.getModel().save(true);
            cmei.setGlobalPreference("methodprofiler", g);
            String l = this.getModel().save(false);
            cmei.setLocalPreference("methodprofiler", l);
        }
        catch (Exception e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not save profiler settings.", e);
        }
    }

    public void doLoad() throws UnmarshalException {
        ConsoleEditorInput cmei = (ConsoleEditorInput)this.getEditorInput();
        try {
            String g = cmei.getGlobalPreference("methodprofiler");
            this.getModel().load(g, true);
            String l = cmei.getLocalPreference("methodprofiler");
            this.getModel().load(l, false);
        }
        catch (UnmarshalException e) {
            throw e;
        }
        catch (UndeclaredThrowableException e) {
            throw e;
        }
        catch (Exception e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not load profiler settings.", e);
        }
        this.setInitialized(true);
    }

    private void setInitialized(boolean initialized) {
        this.m_initialized = initialized;
    }

    private boolean isInitialized() {
        return this.m_initialized;
    }

    public boolean isDirty() {
        return false;
    }

    public synchronized MethodProfilerModel getModel() {
        if (this.m_profilerModel == null) {
            this.m_profilerModel = new MethodProfilerModel(this.getMBeanService(), new NotificationSystem());
        }
        return this.m_profilerModel;
    }
}

