/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.mc.console.ui.profiler.common.Profiler;
import com.jrockit.mc.console.ui.profiler.method.Method;
import com.jrockit.mc.core.model.fields.BooleanField;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.MethodField;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.core.model.fields.TimeSpanField;
import com.jrockit.mc.core.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.core.ui.fields.FieldToolkit;

public class MethodProfilerProvider
extends AbstractFieldTableContentProvider {
    public static int FIELD_COUNT = 0;
    public static final Field FIELD_METHOD = new MethodField(FIELD_COUNT++);
    public static final Field FIELD_METHOD_INVOCATIONS = new NumberField(FIELD_COUNT++);
    public static final Field FIELD_METHOD_TIMING = new TimeSpanField(FIELD_COUNT++);
    public static final Field FIELD_METHOD_TIME_PER_INVOCATION = new TimeSpanField(FIELD_COUNT++, 6);
    public static final Field FIELD_METHOD_INVOCATION_NOT_AVAILABLE = new BooleanField(FIELD_COUNT++);
    public static final Field FIELD_METHOD_TIMING_NOT_AVAILABLE = new BooleanField(FIELD_COUNT++);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.console.ui.profiler.method.MethodProfilerProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FieldToolkit.initializeFields((String)"com.jrockit.mc.console.ui.profiler.method.fields", (Class)clazz);
    }

    public Object[] getColumnObject(Object inputRowElement) {
        if (inputRowElement instanceof Method) {
            Method method = (Method)inputRowElement;
            Object[] result = new Object[FIELD_COUNT];
            result[MethodProfilerProvider.FIELD_METHOD.INDEX] = method;
            result[MethodProfilerProvider.FIELD_METHOD_INVOCATIONS.INDEX] = method.getInvocations();
            result[MethodProfilerProvider.FIELD_METHOD_TIMING.INDEX] = method.getTiming();
            result[MethodProfilerProvider.FIELD_METHOD_TIME_PER_INVOCATION.INDEX] = this.getTimePerInvocation(method.getInvocations(), method.getTiming());
            result[MethodProfilerProvider.FIELD_METHOD_INVOCATION_NOT_AVAILABLE.INDEX] = method.isInvocationCountNotAvailable();
            result[MethodProfilerProvider.FIELD_METHOD_TIMING_NOT_AVAILABLE.INDEX] = method.isTimingNotAvailable();
            return result;
        }
        return new Object[0];
    }

    public Double getTimePerInvocation(Long invocations, Long time) {
        if (invocations == null || time == null) {
            return null;
        }
        long i = invocations;
        long t = time;
        return i > 0L ? new Double((double)t / (double)i) : null;
    }

    public void reset() {
    }

    public Object[] getRowElements(Object inputElement) {
        if (inputElement instanceof Profiler) {
            return ((Profiler)inputElement).getEnabledObjects().toArray();
        }
        return new Object[0];
    }
}

