/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.misc.ClassProxy;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.method.Clazz;
import com.jrockit.mc.console.ui.profiler.method.Messages;
import com.jrockit.mc.console.ui.profiler.method.Method;
import com.jrockit.mc.console.ui.profiler.method.MethodProfiler;
import com.jrockit.mc.console.ui.profiler.method.Template;
import com.jrockit.mc.rjmx.core.IMBeanService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.UnmarshalException;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MethodProfilerModel
implements XmlEnabled {
    private NotificationSystem m_notificationSystem;
    private MethodProfiler m_profiler;

    public MethodProfilerModel(IMBeanService mbeanService, NotificationSystem notificationSystem) {
        this.m_notificationSystem = notificationSystem;
        this.m_profiler = new MethodProfiler(mbeanService, this.m_notificationSystem);
    }

    public void initializeFromXml(Element node) {
        NodeList templateList = node.getElementsByTagName("methodprofiler");
        int i = 0;
        while (i < templateList.getLength()) {
            this.m_profiler.getTemplateContainer().initializeFromXml((Element)templateList.item(i));
            ++i;
        }
    }

    public void exportToXml(Element node) {
        Element methodProfiler = XmlToolkit.createElement((Element)node, (String)"methodprofiler");
        this.m_profiler.getTemplateContainer().exportToXml(methodProfiler);
    }

    public String save(boolean global) throws IOException, SAXException {
        Document doc = XmlToolkit.createNewDocument();
        Element myRoot = doc.getDocumentElement();
        TemplateContainer.setGlobal(doc.getDocumentElement(), global);
        this.exportToXml(myRoot);
        return XmlToolkit.prettyPrint((Element)doc.getDocumentElement());
    }

    public void load(String XML, boolean global) throws IOException, SAXException {
        if (XML != null && XML.trim().length() != 0) {
            byte[] currentXMLBytes = XML.getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentXMLBytes);
            Document doc = XmlToolkit.loadDocumentFromStream((InputStream)byteArrayInputStream);
            Element myRoot = doc.getDocumentElement();
            TemplateContainer.setGlobal(doc.getDocumentElement(), global);
            this.initializeFromXml(myRoot);
        } else {
            this.createDefault(global);
        }
    }

    public void createDefault(boolean global) throws IOException, UnmarshalException {
        Template myTemplate;
        TemplateContainer tc = this.getProfiler().getTemplateContainer();
        if (global) {
            myTemplate = (Template)tc.createTemplate(Messages.MethodProfilerModel_DEFAULT_TEMPLATE_NAME);
            tc.addTemplate(myTemplate);
        } else {
            myTemplate = (Template)tc.getTemplate(Messages.MethodProfilerModel_DEFAULT_TEMPLATE_NAME);
        }
        if (myTemplate != null) {
            myTemplate.setEnabled(true);
            this.createClass(global, myTemplate, "java.lang.Object", "toString");
            this.createClass(global, myTemplate, "java.lang.String", "toString");
            this.createClass(global, myTemplate, "java.lang.StringBuffer", "append");
        }
    }

    public void createClass(boolean global, Template template, String className, String method) throws IOException, UnmarshalException {
        if (!global && template.getClazz(className) == null) {
            return;
        }
        boolean firsttime = false;
        Clazz templateClass = null;
        try {
            ClassProxy classProxy = ClassProxy.forName((String)className, (IMBeanService)this.m_profiler.getMBeanService());
            if (global) {
                templateClass = new Clazz(className);
                template.add(templateClass);
            } else {
                templateClass = template.getClazz(className);
            }
            if (templateClass != null) {
                MethodIdentifier[] identifiers = classProxy.getMethodIdentifiers();
                int n = 0;
                while (n < classProxy.getMethodIdentifiers().length) {
                    Method templateMethod = null;
                    if (global) {
                        templateMethod = new Method(templateClass, identifiers[n]);
                        templateClass.add(templateMethod);
                    } else {
                        templateMethod = templateClass.getMethod(identifiers[n].toString());
                    }
                    if (templateMethod != null && !firsttime && identifiers[n].getMethodName().equalsIgnoreCase(method)) {
                        firsttime = true;
                        templateMethod.setEnabled(true);
                    }
                    ++n;
                }
            }
        }
        catch (ClassNotFoundException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not create default template ", e);
        }
    }

    public String getComponentTag() {
        return null;
    }

    public MethodProfiler getProfiler() {
        return this.m_profiler;
    }

    public NotificationSystem getNotificationSystem() {
        return this.m_notificationSystem;
    }
}

