/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.Profiler;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.method.Clazz;
import com.jrockit.mc.console.ui.profiler.method.Method;
import com.jrockit.mc.console.ui.profiler.method.Template;
import com.jrockit.mc.rjmx.core.IMBeanService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class MethodProfiler
extends Profiler
implements NotificationSystem.ModelListener {
    private TemplateContainer m_templateContainer;
    private IMBeanService m_mbeanService;
    private volatile boolean m_useInvocationCount = true;
    private volatile boolean m_useTiming = true;

    public MethodProfiler(IMBeanService mbeanService, NotificationSystem notificationSystem) {
        super(notificationSystem);
        this.m_templateContainer = new TemplateContainer(notificationSystem, new Template());
        this.m_mbeanService = mbeanService;
        notificationSystem.addListener(this);
    }

    public TemplateContainer getTemplateContainer() {
        return this.m_templateContainer;
    }

    protected IMBeanService getMBeanService() {
        return this.m_mbeanService;
    }

    private boolean profileTiming(Method method) throws IOException {
        boolean dirty = false;
        if (this.getUseTiming()) {
            try {
                long time = this.getMBeanService().getProxyOperations().getTiming(method.getMethodIdentfier());
                Long oldTime = method.getTiming();
                if (oldTime == null || oldTime != time) {
                    dirty = true;
                    method.setTiming(new Long(time));
                }
            }
            catch (Exception t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                method.setTimingNotAvailable(Boolean.TRUE);
                dirty = true;
            }
        }
        return dirty;
    }

    private boolean profileInvocations(Method method) throws IOException {
        boolean dirty = false;
        if (this.getUseInvocationCount()) {
            try {
                long count = this.getMBeanService().getProxyOperations().getInvocationCount(method.getMethodIdentfier());
                Long oldCount = method.getInvocations();
                if (oldCount == null || oldCount != count) {
                    dirty = true;
                    method.setInvocations(new Long(count));
                }
            }
            catch (Exception t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                method.setInvocationCountNotAvailable(Boolean.TRUE);
                dirty = true;
            }
        }
        return dirty;
    }

    public void setUseInvocationCount(boolean useInvocationCount) {
        this.m_useInvocationCount = useInvocationCount;
    }

    public boolean getUseTiming() {
        return this.m_useTiming;
    }

    public boolean getUseInvocationCount() {
        return this.m_useInvocationCount;
    }

    public void setUseTiming(boolean useTiming) {
        this.m_useTiming = useTiming;
    }

    public void onEvent(String event, Object eventData) {
        if ("Use method invocation when profiling".equals(event)) {
            this.setUseInvocationCount(true);
        }
        if ("Don't use method invocation when profiling".equals(event)) {
            this.setUseInvocationCount(false);
        }
        if ("Use method timing when profiling".equals(event)) {
            this.setUseTiming(true);
        }
        if ("Don't use method timing when profiling".equals(event)) {
            this.setUseTiming(false);
        }
    }

    public void reset() {
        Collection c = this.getEnabledObjects();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            method.reset();
        }
    }

    public synchronized Collection getEnabledObjects() {
        HashSet<Method> enabledMethods = new HashSet<Method>();
        Iterator templateIterator = this.m_templateContainer.getTemplates().iterator();
        while (templateIterator.hasNext()) {
            Template template = (Template)templateIterator.next();
            if (!template.getEnabled()) continue;
            Iterator classIterator = template.getAllClasses().iterator();
            while (classIterator.hasNext()) {
                Clazz clazz = (Clazz)classIterator.next();
                Iterator methodIterator = clazz.getAllMethods().iterator();
                while (methodIterator.hasNext()) {
                    Method method = (Method)methodIterator.next();
                    if (!method.getEnabled()) continue;
                    enabledMethods.add(method);
                }
            }
        }
        return enabledMethods;
    }

    protected boolean profile(Object object) throws IOException {
        boolean dirty = false;
        if (object instanceof Method) {
            Method method = (Method)object;
            if (method.isInvocationCountNotAvailable() != null && !method.isInvocationCountNotAvailable().booleanValue() && this.profileInvocations(method)) {
                dirty = true;
            }
            if (method.isTimingNotAvailable() != null && !method.isTimingNotAvailable().booleanValue() && this.profileTiming(method)) {
                dirty = true;
            }
        }
        return dirty;
    }

    protected boolean enableProfiling(Object object, boolean enable) throws IOException {
        if (object instanceof Method) {
            Method method = (Method)object;
            try {
                this.getMBeanService().getProxyOperations().setInvocationCountEnabled(method.getMethodIdentfier(), enable);
                method.setInvocationCountNotAvailable(Boolean.FALSE);
            }
            catch (Exception e) {
                e.printStackTrace();
                method.setInvocationCountNotAvailable(Boolean.TRUE);
            }
            try {
                this.getMBeanService().getProxyOperations().setTimingEnabled(method.getMethodIdentfier(), enable);
                method.setTimingNotAvailable(Boolean.FALSE);
            }
            catch (Exception e) {
                e.printStackTrace();
                method.setTimingNotAvailable(Boolean.TRUE);
            }
            return method.isTimingNotAvailable() != null || method.isInvocationCountNotAvailable() != null;
        }
        return false;
    }
}

