/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.common.util.MalformedDescriptorException;
import com.jrockit.common.util.MethodDescriptor;
import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.mc.common.porting.JDK14Util;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.profiler.method.Clazz;
import com.jrockit.mc.console.ui.profiler.method.MIMethod;
import com.jrockit.mc.console.ui.profiler.method.Messages;
import org.w3c.dom.Element;

public class Method
extends MIMethod
implements XmlEnabled {
    private volatile Long m_invocations = null;
    private volatile Long m_timing = null;
    private volatile boolean m_enabled = false;
    private volatile Boolean m_invocationCountNA = null;
    private volatile Boolean m_timingNA = null;
    private final Clazz m_clazz;
    private static final MethodIdentifier UNKNOWN_METHOD;

    static {
        MethodIdentifier temp = null;
        try {
            temp = new MethodIdentifier(Messages.Method_UNKNOWN, Messages.Method_UNKNOWN, "()V");
        }
        catch (MalformedDescriptorException malformedDescriptorException) {
            // empty catch block
        }
        UNKNOWN_METHOD = temp;
    }

    public Method(Clazz clazz, MethodIdentifier methodIdentfier) {
        this(clazz);
        this.m_methodIdentifier = methodIdentfier;
    }

    public Method(Clazz clazz) {
        super(UNKNOWN_METHOD);
        this.m_clazz = clazz;
    }

    public String getId() {
        return this.m_methodIdentifier.toString();
    }

    public void initializeFromXml(Element node) {
        String value = XmlToolkit.getSetting((Element)node, (String)"enabled", null);
        if (value != null) {
            this.setEnabled(JDK14Util.parseBoolean((String)value));
        }
        this.m_methodIdentifier = Method.createMethodIdentifierFromXml(node);
    }

    public void exportToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)"enabled", (String)Boolean.toString(this.getEnabled()));
        XmlToolkit.setSetting((Element)node, (String)"classname", (String)this.getMethodIdentfier().getClassName());
        XmlToolkit.setSetting((Element)node, (String)"name", (String)this.getMethodIdentfier().getMethodName());
        XmlToolkit.setSetting((Element)node, (String)"descriptor", (String)this.getMethodIdentfier().getDescriptor().getFormalDescriptor());
    }

    public static MethodIdentifier createMethodIdentifierFromXml(Element node) {
        String className = XmlToolkit.getSetting((Element)node, (String)"classname", (String)"");
        String descriptor = XmlToolkit.getSetting((Element)node, (String)"descriptor", (String)"");
        String methodName = XmlToolkit.getSetting((Element)node, (String)"name", (String)"");
        try {
            return new MethodIdentifier(className, methodName, new MethodDescriptor(descriptor));
        }
        catch (MalformedDescriptorException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void reset() {
        this.m_timingNA = null;
        this.m_invocationCountNA = null;
        this.m_timing = null;
        this.m_invocations = null;
    }

    public String toString() {
        return this.getHumanReadable(false, false, true, true, true, true);
    }

    public Clazz getParentClass() {
        return this.m_clazz;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public Long getInvocations() {
        return this.m_invocations;
    }

    public void setInvocations(Long invocations) {
        this.m_invocations = invocations;
    }

    public Boolean isTimingNotAvailable() {
        return this.m_timingNA;
    }

    public Boolean isInvocationCountNotAvailable() {
        return this.m_invocationCountNA;
    }

    public void setTimingNotAvailable(Boolean timingNA) {
        this.m_timingNA = timingNA;
    }

    public void setInvocationCountNotAvailable(Boolean invocationCountNA) {
        this.m_invocationCountNA = invocationCountNA;
    }

    public Long getTiming() {
        return this.m_timing;
    }

    public void setTiming(Long timing) {
        this.m_timing = timing;
    }

    public Boolean notAvailable() {
        Boolean i = this.isInvocationCountNotAvailable();
        Boolean t = this.isTimingNotAvailable();
        if (t == null || i == null) {
            return null;
        }
        return t != false && i != false;
    }

    public String getComponentTag() {
        return null;
    }
}

