/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.common.util.MethodDescriptor;
import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.internal.MethodToolkit;

public class MIMethod
implements IMCMethod {
    public static final char LP = '(';
    public static final char RP = ')';
    public static final char LB = '[';
    public static final char RB = ']';
    public static final char CLASS_SUFFIX = ';';
    public static final char CLASS_PREFIX = 'L';
    public static final char PACKAGE_SEPARATOR = '.';
    public static final String COMMA_SEPARATOR = ", ";
    public static final String ARRAY = "[]";
    protected MethodIdentifier m_methodIdentifier;

    public MIMethod(MethodIdentifier methodIdentifier) {
        this.m_methodIdentifier = methodIdentifier;
    }

    protected MIMethod() {
    }

    public String getClassName() {
        return this.m_methodIdentifier.getNonQualifiedClassName();
    }

    public String getMethodName() {
        return this.m_methodIdentifier.getMethodName();
    }

    public String getPackageName() {
        return MethodToolkit.getPackageName((String)this.m_methodIdentifier.getClassName());
    }

    public Boolean getIsNative() {
        return Boolean.FALSE;
    }

    public MethodIdentifier getMethodIdentfier() {
        return this.m_methodIdentifier;
    }

    public int hashCode() {
        return this.getMethodIdentfier().getClassName().hashCode() ^ this.getMethodIdentfier().getMethodName().hashCode() ^ this.getMethodIdentfier().getDescriptor().hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof MIMethod)) {
            return false;
        }
        MIMethod thatMethod = (MIMethod)that;
        return thatMethod.getMethodIdentfier().getClassName().equals(this.getMethodIdentfier().getClassName()) && thatMethod.getMethodIdentfier().getMethodName().equals(this.getMethodIdentfier().getMethodName()) && thatMethod.getMethodIdentfier().getDescriptor().equals((Object)this.getMethodIdentfier().getDescriptor());
    }

    public String getHumanReadable(boolean showReturnValue, boolean showReturnValuePackage, boolean showClassName, boolean showClassPackageName, boolean showArguments, boolean showArgumentsPackage) {
        String ret = new String();
        try {
            MethodIdentifier mi = this.getMethodIdentfier();
            MethodDescriptor md = mi.getDescriptor();
            if (showReturnValue) {
                ret = String.valueOf(ret) + this.getReturnType(md.getFormalDescriptor(), showReturnValuePackage) + " ";
            }
            if (showClassName) {
                ret = String.valueOf(ret) + (showClassPackageName ? mi.getClassName() : mi.getNonQualifiedClassName()) + ".";
            }
            ret = String.valueOf(ret) + mi.getMethodName();
            String arguments = this.getParameters(md.getFormalDescriptor(), showArgumentsPackage);
            ret = !"()".equals(arguments) && !showArguments ? String.valueOf(ret) + "(...)" : String.valueOf(ret) + arguments;
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public String getReturnType(String descriptor, boolean qualified) throws Exception {
        StringBuffer output = new StringBuffer();
        this.parseToken(output, descriptor.substring(descriptor.indexOf(41) + 1), 0, qualified);
        return output.toString();
    }

    public String getParameters(String descriptor, boolean qualified) throws Exception {
        String input = descriptor.substring(descriptor.indexOf(40) + 1, descriptor.lastIndexOf(41));
        StringBuffer output = new StringBuffer(Character.toString('('));
        int next = -1;
        int current = 0;
        while (current < input.length()) {
            next = this.parseToken(output, input, current, qualified);
            if (next == current) break;
            if (next < input.length()) {
                output.append(COMMA_SEPARATOR);
            }
            current = next;
        }
        return output.append(')').toString();
    }

    private int parseToken(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        if (input.charAt(position) == '[') {
            return this.readArray(output, input, position, qualified);
        }
        if (input.charAt(position) == 'L') {
            return this.readComponentType(output, input, position, qualified);
        }
        return this.readPrimitive(output, input, position, qualified);
    }

    private int readArray(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        return this.write(output, ARRAY, this.parseToken(output, input, position + 1, qualified));
    }

    private int readPrimitive(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        return this.write(output, this.getPrimitiveType(input.charAt(position)), position + 1);
    }

    private int write(StringBuffer output, String string, int next_position) {
        output.append(string);
        return next_position;
    }

    private int readComponentType(StringBuffer output, String input, int position, boolean qualified) {
        int endIndex = input.indexOf(59, position);
        return this.write(output, this.getClass(input.substring(position + 1, endIndex), qualified), endIndex + 1);
    }

    private String getClass(String clazz, boolean qualified) {
        return qualified ? clazz : clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    private String getPrimitiveType(char ch) {
        if (ch == 'Z') {
            return Boolean.TYPE.toString();
        }
        if (ch == 'B') {
            return Byte.TYPE.toString();
        }
        if (ch == 'S') {
            return Short.TYPE.toString();
        }
        if (ch == 'I') {
            return Integer.TYPE.toString();
        }
        if (ch == 'C') {
            return Character.TYPE.toString();
        }
        if (ch == 'J') {
            return Long.TYPE.toString();
        }
        if (ch == 'F') {
            return Float.TYPE.toString();
        }
        if (ch == 'D') {
            return Double.TYPE.toString();
        }
        if (ch == 'V') {
            return Void.TYPE.toString();
        }
        return null;
    }

    public String getFileName() {
        return null;
    }

    public Integer getLineNumber() {
        return null;
    }

    public String getFormalDescriptor() {
        return this.m_methodIdentifier.getDescriptor().getFormalDescriptor();
    }

    public Long getClassLoaderId() {
        return null;
    }

    public Integer getModifier() {
        return null;
    }
}

