/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.method;

import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.common.internal.MethodToolkit;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.method.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Clazz
implements XmlEnabled,
IMCType {
    protected String m_className;
    protected final Map m_methods = Collections.synchronizedMap(new TreeMap());

    public Clazz(String className) {
        this.m_className = className;
    }

    public void add(Method method) {
        this.m_methods.put(method.getId(), method);
    }

    public void removeMethod(Method method) {
        this.m_methods.remove(method.getId());
    }

    public Collection getAllMethods() {
        return this.m_methods.values();
    }

    public Method getMethod(String methodID) {
        return (Method)this.m_methods.get(methodID);
    }

    public void initializeFromXml(Element node) {
        this.setClassName(XmlToolkit.getSetting((Element)node, (String)"classname", (String)""));
        NodeList methodList = node.getElementsByTagName("method");
        if (methodList != null) {
            int i = 0;
            while (i < methodList.getLength()) {
                if (TemplateContainer.isGlobal(node)) {
                    Method method = new Method(this);
                    method.initializeFromXml((Element)methodList.item(i));
                    this.add(method);
                } else {
                    Method prototype = new Method(this);
                    prototype.initializeFromXml((Element)methodList.item(i));
                    Method actual = this.getMethod(prototype.getId());
                    if (actual != null) {
                        actual.initializeFromXml((Element)methodList.item(i));
                    }
                }
                ++i;
            }
        }
    }

    public void exportToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)"classname", (String)this.getClassName());
        Iterator iter = this.m_methods.values().iterator();
        while (iter.hasNext()) {
            Element methodElement = XmlToolkit.createElement((Element)node, (String)"method");
            ((Method)iter.next()).exportToXml(methodElement);
        }
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public boolean hasMethods() {
        return !this.m_methods.isEmpty();
    }

    public String getComponentTag() {
        return null;
    }

    public String getPackageName() {
        return MethodToolkit.getPackageName((String)this.m_className);
    }

    public String getTypeName() {
        return MethodToolkit.getTypeName((String)this.m_className);
    }

    public Boolean getIsArray() {
        return Boolean.FALSE;
    }

    public Boolean getIsPrimitive() {
        return Boolean.FALSE;
    }

    public String getDescriptor() {
        return null;
    }
}

