/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.exception;

import com.jrockit.mc.common.porting.JDK14Util;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.profiler.common.AbstractTemplate;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.exception.Messages;
import com.jrockit.mc.console.ui.profiler.exception.Package;
import com.jrockit.mc.console.ui.profiler.exception.ProfiledException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Template
extends AbstractTemplate
implements XmlEnabled {
    HashMap m_packages = new HashMap();

    public Template(String name) {
        super(name);
    }

    public Template() {
        super(Messages.Template_DEFAULT_TEMPLATE_NAME);
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void add(Package pack) {
        this.m_packages.put(pack.getName(), pack);
    }

    public void removePackage(Package pack) {
        this.m_packages.remove(pack.getName());
    }

    public Object clone() {
        return new Template();
    }

    public Collection getAllPackages() {
        return this.m_packages.values();
    }

    public String getComponentTag() {
        return null;
    }

    public ProfiledException addException(String fullClassName, boolean includeSubClasses) {
        ProfiledException exception;
        String packageName = Package.getPackageName(fullClassName);
        Package pakkage = (Package)this.m_packages.get(packageName);
        if (pakkage == null) {
            pakkage = new Package(packageName);
            this.m_packages.put(packageName, pakkage);
        }
        if ((exception = pakkage.getException(fullClassName)) == null) {
            exception = new ProfiledException(fullClassName, pakkage, includeSubClasses);
            pakkage.add(exception);
        }
        return exception;
    }

    public ProfiledException getException(String fullClassName) {
        String packageName = Package.getPackageName(fullClassName);
        Package pakkage = (Package)this.m_packages.get(packageName);
        if (pakkage == null) {
            return null;
        }
        return pakkage.getException(fullClassName);
    }

    public void initializeFromXml(Element node) {
        this.setEnabled(JDK14Util.parseBoolean((String)XmlToolkit.getSetting((Element)node, (String)"enabled", (String)"false")));
        this.setName(XmlToolkit.getSetting((Element)node, (String)"name", (String)"unknown"));
        NodeList packageList = node.getElementsByTagName("package");
        if (packageList != null) {
            int i = 0;
            while (i < packageList.getLength()) {
                if (TemplateContainer.isGlobal(node)) {
                    Package pakkage = new Package("");
                    pakkage.initializeFromXml((Element)packageList.item(i));
                    this.add(pakkage);
                } else {
                    Package prototype = new Package("");
                    prototype.initializeFromXml((Element)packageList.item(i));
                    Package actual = this.getPackage(prototype.getName());
                    if (actual != null) {
                        actual.initializeFromXml((Element)packageList.item(i));
                    }
                }
                ++i;
            }
        }
    }

    private Package getPackage(String name) {
        return (Package)this.m_packages.get(name);
    }

    public void exportToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)"enabled", (String)Boolean.toString(this.getEnabled()));
        XmlToolkit.setSetting((Element)node, (String)"name", (String)this.getName());
        Iterator iter = this.m_packages.values().iterator();
        while (iter.hasNext()) {
            Element methodElement = XmlToolkit.createElement((Element)node, (String)"package");
            ((Package)iter.next()).exportToXml(methodElement);
        }
    }
}

