/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.exception;

import com.jrockit.mc.console.ui.profiler.ProfilerPlugin;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.exception.ExceptionProfiler;
import com.jrockit.mc.console.ui.profiler.exception.ExceptionProfilerProvider;
import com.jrockit.mc.console.ui.profiler.exception.Messages;
import com.jrockit.mc.console.ui.profiler.exception.ProfilingLabelProvider;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.sections.FieldTableViewerSectionPart;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.core.ui.fields.FieldLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ProfilingPart
extends FieldTableViewerSectionPart
implements NotificationSystem.ModelListener,
DisposeListener {
    protected static Field[] FIELD_PROTOTYPES = new Field[]{ExceptionProfilerProvider.FIELD_EXCEPTION_CLASS, ExceptionProfilerProvider.FIELD_EXCEPTION_COUNT, ExceptionProfilerProvider.FIELD_COUNT_SUBCLASSES, ExceptionProfilerProvider.FIELD_COUNT_NOT_AVAILABLE};
    protected NotificationSystem m_notificationSystem;
    protected ExceptionProfiler m_profiler;

    public ProfilingPart(Composite parent, FormToolkit toolkit, ExceptionProfiler profiler, NotificationSystem notificationSystem) {
        super(parent, toolkit, MCSectionPart.getAccessibilityDescriptionStyle(), "exception.count.information", FIELD_PROTOTYPES, ProfilerPlugin.getDefault().getMCDialogSettings());
        this.getSection().addDisposeListener((DisposeListener)this);
        this.m_profiler = profiler;
        this.m_notificationSystem = notificationSystem;
        this.m_notificationSystem.addListener(this);
    }

    public void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new ExceptionProfilerProvider());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new FieldLabelProvider(this.getFields(), (IBaseLabelProvider)new ProfilingLabelProvider()));
        this.setSortColumn(ExceptionProfilerProvider.FIELD_EXCEPTION_CLASS, true);
        this.getTableViewer().setInput((Object)this.m_profiler);
    }

    protected void setupSelectionListeners() {
    }

    protected Composite createTopControl(Composite container) {
        return null;
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.ProfilingPart_SECTION_TEXT);
        if (CorePlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void onEvent(String event, Object eventData) {
        if ("Template model has changed".equals(event) || "Available templates changed".equals(event) || "Exception model has changed".equals(event) || "New profiling data is available".equals(event)) {
            this.getTableViewer().refresh();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.m_notificationSystem.removeListener(this);
    }
}

