/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.exception;

import com.jrockit.mc.console.ui.profiler.ProfilerPlugin;
import com.jrockit.mc.console.ui.profiler.exception.Messages;
import com.jrockit.mc.core.CorePlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProfiledExceptionEditDialog
extends TitleAreaDialog {
    String m_exceptionName = "";
    boolean m_includeSubClasses;
    boolean m_edit;
    private Button m_checkButton;
    private Text m_text;

    public ProfiledExceptionEditDialog(Shell parent, boolean edit, String exceptionName, boolean includeSubClasses) {
        super(parent);
        this.setTitleImage(ProfilerPlugin.getDefault().getImage("exception-profile-wiz-16.gif"));
        this.m_edit = edit;
        this.m_exceptionName = exceptionName;
        this.m_includeSubClasses = includeSubClasses;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setImage(CorePlugin.getDefault().getImage("jexception_obj.png"));
        Control contents = super.createContents(parent);
        if (this.m_edit) {
            this.setTitle(String.valueOf(Messages.ProfiledExceptionEditDialog_TITLE_EDIT) + this.m_exceptionName);
            this.getShell().setText(String.valueOf(Messages.ProfiledExceptionEditDialog_TITLE_EDIT) + this.m_exceptionName);
        } else {
            this.setTitle(Messages.ProfiledExceptionEditDialog_TITLE_ADD);
            this.getShell().setText(Messages.ProfiledExceptionEditDialog_TITLE_ADD);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalIndent = 8;
        Label label = new Label(composite, 0);
        if (this.m_edit) {
            label.setText(Messages.ProfiledExceptionEditDialog_LABEL_EDIT);
        } else {
            label.setText(Messages.ProfiledExceptionEditDialog_LABEL_ADD);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalIndent = 8;
        this.m_text = new Text(composite, 2048);
        this.m_text.setText(this.m_exceptionName);
        this.m_text.setLayoutData((Object)gd);
        this.m_text.setEnabled(!this.m_edit);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalIndent = 8;
        this.m_checkButton = new Button(composite, 32);
        this.m_checkButton.setText(Messages.ProfiledExceptionEditDialog_CHECK_INCLUDE_SUBCLASSES_TEXT);
        this.m_checkButton.setSelection(this.m_includeSubClasses);
        this.m_checkButton.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public boolean getIncludeSubClasses() {
        return this.m_includeSubClasses;
    }

    public String getExceptioName() {
        return this.m_exceptionName;
    }

    public void okPressed() {
        try {
            this.m_includeSubClasses = this.m_checkButton.getSelection();
            this.m_exceptionName = this.m_text.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.okPressed();
    }
}

