/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.exception;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.exception.Messages;
import com.jrockit.mc.console.ui.profiler.exception.ProfiledException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Package
implements XmlEnabled {
    protected String m_packageName;
    HashMap m_exception = new HashMap();

    public Package(String packageName) {
        this.m_packageName = packageName;
    }

    public static String getPackageName(String className) {
        int i = className.lastIndexOf(".");
        return i < 1 ? "" : className.substring(0, i);
    }

    public void add(ProfiledException exception) {
        this.m_exception.put(exception.getFullName(), exception);
    }

    public void removeException(ProfiledException exception) {
        this.m_exception.remove(exception.getFullName());
    }

    public void initializeFromXml(Element node) {
        this.setPackageName(XmlToolkit.getSetting((Element)node, (String)"name", (String)"unknown"));
        NodeList methodList = node.getElementsByTagName("exception");
        if (methodList != null) {
            int i = 0;
            while (i < methodList.getLength()) {
                if (TemplateContainer.isGlobal(node)) {
                    ProfiledException exception = new ProfiledException(Messages.Package_UNKNOWN_EXCEPTION_NAME, this, false);
                    exception.initializeFromXml((Element)methodList.item(i));
                    this.add(exception);
                } else {
                    ProfiledException prototype = new ProfiledException(Messages.Package_UNKNOWN_EXCEPTION_NAME, this, false);
                    prototype.initializeFromXml((Element)methodList.item(i));
                    ProfiledException actual = this.getException(prototype.getFullName());
                    if (actual != null) {
                        actual.initializeFromXml((Element)methodList.item(i));
                    }
                }
                ++i;
            }
        }
    }

    public void exportToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)"name", (String)this.getName());
        Iterator iter = this.m_exception.values().iterator();
        while (iter.hasNext()) {
            Element methodElement = XmlToolkit.createElement((Element)node, (String)"exception");
            ((ProfiledException)iter.next()).exportToXml(methodElement);
        }
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
    }

    public boolean hasExceptions() {
        return !this.m_exception.isEmpty();
    }

    public String getName() {
        return this.m_packageName;
    }

    public Collection getExceptions() {
        return this.m_exception.values();
    }

    public String getComponentTag() {
        return null;
    }

    public ProfiledException getException(String fullClassName) {
        return (ProfiledException)this.m_exception.get(fullClassName);
    }
}

