/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.exception;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.ConsoleEditorInput;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.profiler.common.ProfileMonitor;
import com.jrockit.mc.console.ui.profiler.exception.ExceptionCountModel;
import com.jrockit.mc.console.ui.profiler.exception.ExceptionSashSection;
import java.util.logging.Level;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;

public class ExceptionTab
extends ConsoleTab {
    private ExceptionCountModel m_profilerModel;
    private boolean m_initialized;
    private ProfileMonitor profileMonitor;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.profileMonitor = new ProfileMonitor(this.getModel().getNotificationSystem(), this.getModel().getProfiler());
        this.doLoad();
        ExceptionSashSection ess = new ExceptionSashSection(managedForm.getForm().getBody(), managedForm.getToolkit(), "com.jrockit.mc.console.ui.profiler.exception.sash", this.getModel());
        managedForm.addPart((IFormPart)ess);
    }

    public void dispose() {
        super.dispose();
        if (this.isInitialized() && this.profileMonitor != null) {
            this.profileMonitor.shutDown();
        }
        this.doSave();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public void setInitialized(boolean initialized) {
        this.m_initialized = initialized;
    }

    public void doSave() {
        if (!this.isInitialized()) {
            return;
        }
        try {
            ConsoleEditorInput cmei = (ConsoleEditorInput)this.getEditorInput();
            String g = this.getModel().save(true);
            cmei.setGlobalPreference("exceptioncounter", g);
            String l = this.getModel().save(false);
            cmei.setLocalPreference("exceptioncounter", l);
        }
        catch (Exception e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not save profiler settings.", e);
        }
    }

    public void doLoad() {
        ConsoleEditorInput cmei = (ConsoleEditorInput)this.getEditorInput();
        try {
            String g = cmei.getGlobalPreference("exceptioncounter");
            this.getModel().load(g, true);
            String l = cmei.getLocalPreference("exceptioncounter");
            this.getModel().load(l, false);
        }
        catch (Exception e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not load profiler settings.", e);
        }
        this.setInitialized(true);
    }

    public synchronized ExceptionCountModel getModel() {
        if (this.m_profilerModel == null) {
            this.m_profilerModel = new ExceptionCountModel(this.getMBeanService());
        }
        return this.m_profilerModel;
    }
}

