/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.exception;

import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.Profiler;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.exception.Package;
import com.jrockit.mc.console.ui.profiler.exception.ProfiledException;
import com.jrockit.mc.console.ui.profiler.exception.Template;
import com.jrockit.mc.rjmx.core.IMBeanService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ExceptionProfiler
extends Profiler {
    private TemplateContainer m_templateContainer;
    private IMBeanService m_mbeanService;

    public ExceptionProfiler(IMBeanService mbeanService, NotificationSystem notificationSystem) {
        super(notificationSystem);
        this.m_templateContainer = new TemplateContainer(notificationSystem, new Template());
        this.m_mbeanService = mbeanService;
    }

    public TemplateContainer getTemplateContainer() {
        return this.m_templateContainer;
    }

    public synchronized Collection getEnabledObjects() {
        HashSet<ProfiledException> enabledExceptions = new HashSet<ProfiledException>();
        Iterator templateIterator = this.m_templateContainer.getTemplates().iterator();
        while (templateIterator.hasNext()) {
            Template template = (Template)templateIterator.next();
            if (!template.getEnabled()) continue;
            Iterator packageIterator = template.getAllPackages().iterator();
            while (packageIterator.hasNext()) {
                Package pakkage = (Package)packageIterator.next();
                Iterator exceptionIterator = pakkage.getExceptions().iterator();
                while (exceptionIterator.hasNext()) {
                    ProfiledException exception = (ProfiledException)exceptionIterator.next();
                    if (!exception.getEnabled()) continue;
                    enabledExceptions.add(exception);
                }
            }
        }
        return enabledExceptions;
    }

    private IMBeanService getMBeanService() {
        return this.m_mbeanService;
    }

    public void reset() {
        Collection c = this.getEnabledObjects();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ProfiledException p = (ProfiledException)it.next();
            p.reset();
        }
    }

    protected boolean enableProfiling(Object object, boolean enable) throws IOException {
        if (object instanceof ProfiledException) {
            ProfiledException profiledException = (ProfiledException)object;
            try {
                this.getMBeanService().getProxyOperations().setExceptionCountEnabled(profiledException.getFullName(), enable, profiledException.getIncludeSubClasses());
                profiledException.setNotAvailable(Boolean.FALSE);
                return true;
            }
            catch (Exception t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                profiledException.setNotAvailable(Boolean.TRUE);
            }
        }
        return false;
    }

    protected boolean profile(Object object) throws IOException {
        ProfiledException exception;
        boolean dirty = false;
        if (object instanceof ProfiledException && (exception = (ProfiledException)object).getNotAvailable() != null && !exception.getNotAvailable().booleanValue()) {
            try {
                long count = this.getMBeanService().getProxyOperations().getExceptionCount(exception.getFullName());
                Long oldCount = exception.getInvocations();
                if (oldCount == null || oldCount != count) {
                    exception.setInvocations(new Long(count));
                    dirty = true;
                }
            }
            catch (Exception t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                dirty = true;
                exception.setNotAvailable(Boolean.TRUE);
            }
        }
        return dirty;
    }
}

