/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.exception;

import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.exception.ExceptionLabelProvider;
import com.jrockit.mc.console.ui.profiler.exception.ExceptionModelProvider;
import com.jrockit.mc.console.ui.profiler.exception.Messages;
import com.jrockit.mc.console.ui.profiler.exception.Package;
import com.jrockit.mc.console.ui.profiler.exception.ProfiledException;
import com.jrockit.mc.console.ui.profiler.exception.ProfiledExceptionEditDialog;
import com.jrockit.mc.console.ui.profiler.exception.Template;
import com.jrockit.mc.core.sections.ViewerSectionPart;
import java.util.Iterator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExceptionPart
extends ViewerSectionPart
implements IPartSelectionListener,
NotificationSystem.ModelListener,
DisposeListener {
    private final NotificationSystem m_notificationSystem;
    private Button addButton;
    private Button deletebutton;
    private Button editButton;

    public ExceptionPart(Composite parent, FormToolkit toolkit, NotificationSystem notificationSystem) {
        super(parent, toolkit, 384, "exception.template");
        this.m_notificationSystem = notificationSystem;
    }

    private NotificationSystem getNotificationSystem() {
        return this.m_notificationSystem;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.getSection().addDisposeListener((DisposeListener)this);
        this.m_notificationSystem.addListener(this);
    }

    protected Viewer createViewer(Composite parent) {
        int style = 8389410;
        Tree tree = this.getFormToolkit().createTree(parent, style);
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(tree);
        return viewer;
    }

    protected void initializePart() {
        super.initializePart();
        this.getCheckboxTreeViewer().setContentProvider((IContentProvider)new ExceptionModelProvider());
        this.getCheckboxTreeViewer().setLabelProvider((IBaseLabelProvider)new ExceptionLabelProvider());
        this.getCheckboxTreeViewer().setUseHashlookup(true);
        this.getCheckboxTreeViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object object = event.getElement();
                boolean enabled = event.getChecked();
                if (object instanceof Package) {
                    Package pakkage = (Package)object;
                    ExceptionPart.this.setClassEnabled(pakkage, enabled);
                    ExceptionPart.this.refreshPackageCheck(pakkage);
                    ExceptionPart.this.getNotificationSystem().sendEvent("Exception model has changed");
                }
                if (object instanceof ProfiledException) {
                    ProfiledException profiledException = (ProfiledException)object;
                    ExceptionPart.this.setMethodEnabled(profiledException, enabled);
                    ExceptionPart.this.refreshPackageCheck(profiledException.getParent());
                    ExceptionPart.this.getNotificationSystem().sendEvent("Exception model has changed");
                }
            }
        });
        this.getCheckboxTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExceptionPart.this.updateButtons();
            }
        });
        this.getCheckboxTreeViewer().setSorter(new ViewerSorter());
    }

    protected void initializeSection(Section section) {
        this.getSection().setText(Messages.ExceptionPart_SECTION_AVAILABLE_EXCEPTIONS_TEXT);
        this.getSection().setDescription(Messages.ExceptionPart_SECTION_AVAILABLE_EXCEPTIONS_DESCRIPTION);
        this.getSection().setExpanded(true);
    }

    protected Composite createViewerClient(IManagedForm form, FormToolkit toolkit, Composite parent) {
        Composite client = toolkit.createComposite((Composite)this.getSection(), 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gd = new GridData(1810);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 100;
        gd.heightHint = 100;
        this.m_viewer = this.createViewer(client);
        this.m_viewer.getControl().setLayoutData((Object)gd);
        gd = new GridData(2);
        Composite buttonContainer = this.createButtons(toolkit, client);
        buttonContainer.setLayoutData((Object)gd);
        this.getFormToolkit().paintBordersFor(client);
        return client;
    }

    protected void setMethodEnabled(ProfiledException ProfiledException2, boolean enabled) {
        if (enabled != ProfiledException2.getEnabled()) {
            ProfiledException2.setEnabled(enabled);
        }
    }

    void setClassEnabled(Package Package2, boolean enabled) {
        Iterator it = Package2.getExceptions().iterator();
        while (it.hasNext()) {
            this.setMethodEnabled((ProfiledException)it.next(), enabled);
        }
    }

    public void refreshTemplateChecked(Template template) {
        if (template != null) {
            Iterator packageIterator = template.getAllPackages().iterator();
            while (packageIterator.hasNext()) {
                this.refreshPackageCheck((Package)packageIterator.next());
            }
        }
    }

    void refreshPackageCheck(Package pakkage) {
        int totalMethodCount = pakkage.getExceptions().size();
        if (totalMethodCount == 0) {
            return;
        }
        int enabledCount = 0;
        Iterator it = pakkage.getExceptions().iterator();
        while (it.hasNext()) {
            ProfiledException profiledException = (ProfiledException)it.next();
            this.refreshExceptionCheck(profiledException);
            if (!profiledException.getEnabled()) continue;
            ++enabledCount;
        }
        this.getCheckboxTreeViewer().setGrayed((Object)pakkage, enabledCount < totalMethodCount && enabledCount != 0);
        this.getCheckboxTreeViewer().setChecked((Object)pakkage, enabledCount > 0);
    }

    void refreshExceptionCheck(ProfiledException profiledException) {
        this.getCheckboxTreeViewer().setChecked((Object)profiledException, profiledException.getEnabled());
    }

    private Composite createButtons(FormToolkit toolkit, Composite client) {
        Composite buttonContainer = toolkit.createComposite(client, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.createAddButton(toolkit, buttonContainer);
        this.createEditButton(toolkit, buttonContainer);
        this.createDeleteButton(toolkit, buttonContainer);
        return buttonContainer;
    }

    private void createAddButton(FormToolkit toolkit, Composite buttonContainer) {
        GridData gd = new GridData(4, 1, true, false);
        this.addButton = toolkit.createButton(buttonContainer, Messages.ExceptionPart_BUTTON_ADD_TEXT, 8);
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionPart.this.onAdd();
            }
        });
    }

    private void createEditButton(FormToolkit toolkit, Composite buttonContainer) {
        GridData gd = new GridData(4, 1, true, false);
        this.editButton = toolkit.createButton(buttonContainer, Messages.ExceptionPart_BUTTON_EDIT_TEXT, 8);
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionPart.this.onEdit();
            }
        });
    }

    private void createDeleteButton(FormToolkit toolkit, Composite buttonContainer) {
        this.deletebutton = toolkit.createButton(buttonContainer, Messages.ExceptionPart_BUTTON_DELETE_TEXT, 8);
        GridData gd = new GridData(2);
        gd.grabExcessHorizontalSpace = true;
        this.deletebutton.setLayoutData((Object)gd);
        this.deletebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionPart.this.onDelete();
            }
        });
    }

    protected void onAdd() {
        Object o = this.getCheckboxTreeViewer().getInput();
        if (o instanceof Template) {
            Template template = (Template)o;
            ProfiledExceptionEditDialog peed = new ProfiledExceptionEditDialog(Display.getCurrent().getActiveShell(), false, "java.lang.Exception", false);
            if (peed.open() != 0) {
                return;
            }
            if (peed.getExceptioName().trim().length() == 0) {
                return;
            }
            template.addException(peed.getExceptioName(), peed.getIncludeSubClasses());
            this.getNotificationSystem().sendEvent("Template model has changed");
            this.getCheckboxTreeViewer().refresh();
            this.getForm().reflow(true);
        }
    }

    private void onEdit() {
        Object o = this.getSelected();
        if (o instanceof ProfiledException) {
            ProfiledException profiledException = (ProfiledException)o;
            ProfiledExceptionEditDialog peed = new ProfiledExceptionEditDialog(Display.getCurrent().getActiveShell(), true, profiledException.getFullName(), profiledException.getIncludeSubClasses());
            if (peed.open() != 0) {
                return;
            }
            if (peed.getExceptioName().trim().length() == 0) {
                return;
            }
            boolean inc = peed.getIncludeSubClasses();
            if (profiledException.getIncludeSubClasses() != inc) {
                profiledException.setIncludeSubClasses(inc);
                this.getNotificationSystem().sendEvent("Template model has changed");
                this.getCheckboxTreeViewer().refresh();
            }
        }
    }

    protected void onDelete() {
        Object o = this.getCheckboxTreeViewer().getInput();
        if (o instanceof Template) {
            boolean dirty = false;
            Template template = (Template)o;
            IStructuredSelection s = (IStructuredSelection)this.getCheckboxTreeViewer().getSelection();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (object instanceof Package) {
                    template.removePackage((Package)object);
                    dirty = true;
                }
                if (!(object instanceof ProfiledException)) continue;
                ProfiledException exception = (ProfiledException)object;
                exception.getParent().removeException(exception);
                dirty = true;
            }
            if (dirty) {
                this.getNotificationSystem().sendEvent("Exception model has changed");
            }
        }
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() == 1) {
            Object o = ssel.getFirstElement();
            if (o == this.getCheckboxTreeViewer().getInput()) {
                return;
            }
            this.getCheckboxTreeViewer().setInput(o);
            this.refresh();
        } else {
            this.getCheckboxTreeViewer().setInput(null);
            this.refresh();
        }
    }

    private CheckboxTreeViewer getCheckboxTreeViewer() {
        return (CheckboxTreeViewer)this.getViewer();
    }

    private void updateButtons() {
        this.addButton.setEnabled(this.getCheckboxTreeViewer().getInput() != null);
        this.deletebutton.setEnabled(this.getSelected() != null);
        this.editButton.setEnabled(this.getSelected() instanceof ProfiledException);
    }

    private Object getSelected() {
        IStructuredSelection s = (IStructuredSelection)this.getCheckboxTreeViewer().getSelection();
        return s.getFirstElement();
    }

    public void refreshPart() {
        this.getCheckboxTreeViewer().refresh();
        this.updateButtons();
        Template template = (Template)this.getCheckboxTreeViewer().getInput();
        if (template == null) {
            this.getSection().setText(Messages.ExceptionPart_SECTION_NO_TEMPLATE_SELECTED_TEXT);
            this.getSection().setDescription(Messages.ExceptionPart_SECTION_NO_TEMPLATE_SELECTED_DESCRIPTION);
            this.getSection().layout();
            this.getSection().redraw();
        } else {
            this.getSection().setText(template.getName());
            this.getSection().setDescription(Messages.ExceptionPart_SECTION_TEMPLATE_ADD_EXCEPTIONS);
            this.getSection().layout();
            this.getSection().redraw();
            this.refreshTemplateChecked(template);
        }
        this.getForm().reflow(true);
    }

    public void setEnable(boolean enabled) {
        this.deletebutton.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.getSection().setEnabled(enabled);
        this.getSection().update();
    }

    public void onEvent(String event, Object eventData) {
        if ("Profiling has now stopped".equals(event)) {
            this.setEnable(true);
        }
        if ("Profiling has now started".equals(event)) {
            this.setEnable(false);
        }
        if ("Exception model has changed".equals(event)) {
            if (eventData instanceof Package) {
                this.refreshPackageCheck((Package)eventData);
            } else {
                this.refresh();
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.m_notificationSystem.removeListener(this);
    }
}

