/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.exception;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.exception.ExceptionProfiler;
import com.jrockit.mc.console.ui.profiler.exception.Messages;
import com.jrockit.mc.console.ui.profiler.exception.ProfiledException;
import com.jrockit.mc.console.ui.profiler.exception.Template;
import com.jrockit.mc.rjmx.core.IMBeanService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExceptionCountModel
implements XmlEnabled {
    private ExceptionProfiler m_profiler;
    private NotificationSystem m_notificationSystem = new NotificationSystem();

    public ExceptionCountModel(IMBeanService mbeanService) {
        this.m_profiler = new ExceptionProfiler(mbeanService, this.m_notificationSystem);
    }

    public void initializeFromXml(Element node) {
        NodeList templateList = node.getElementsByTagName("exceptioncounter");
        int i = 0;
        while (i < templateList.getLength()) {
            this.m_profiler.getTemplateContainer().initializeFromXml((Element)templateList.item(i));
            ++i;
        }
    }

    public void exportToXml(Element node) {
        Element methodProfiler = XmlToolkit.createElement((Element)node, (String)"exceptioncounter");
        this.m_profiler.getTemplateContainer().exportToXml(methodProfiler);
    }

    public String save(boolean global) throws IOException, SAXException {
        Document doc = XmlToolkit.createNewDocument();
        Element myRoot = doc.getDocumentElement();
        TemplateContainer.setGlobal(doc.getDocumentElement(), global);
        this.exportToXml(myRoot);
        return XmlToolkit.prettyPrint((Element)doc.getDocumentElement());
    }

    public void load(String XML, boolean global) throws IOException, SAXException {
        if (XML != null && XML.trim().length() != 0) {
            byte[] currentXMLBytes = XML.getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentXMLBytes);
            Document doc = XmlToolkit.loadDocumentFromStream((InputStream)byteArrayInputStream);
            Element myRoot = doc.getDocumentElement();
            TemplateContainer.setGlobal(doc.getDocumentElement(), global);
            this.initializeFromXml(myRoot);
        } else {
            this.createDefault(global);
        }
    }

    private void createDefault(boolean global) {
        Template template;
        if (global) {
            template = new Template(Messages.ExceptionCountModel_MY_PROFILED_EXCEPTIONS);
            this.m_profiler.getTemplateContainer().addTemplate(template);
        } else {
            template = (Template)this.m_profiler.getTemplateContainer().getTemplate(Messages.ExceptionCountModel_MY_PROFILED_EXCEPTIONS);
        }
        if (template != null) {
            template.setEnabled(true);
            String[] defaultExceptions = new String[]{"java.lang.IndexOutOfBoundsException", "java.lang.NullPointerException", "java.lang.RuntimeException", "java.lang.Exception", "java.io.IOException", "java.lang.ClassCastException", "java.lang.ClassNotFoundException", "java.lang.NumberFormatException", "java.lang.Throwable", "java.lang.reflect.InvocationTargetException"};
            int n = 0;
            while (n < defaultExceptions.length) {
                ProfiledException exception;
                if (global) {
                    exception = template.addException(defaultExceptions[n], true);
                } else {
                    exception = template.getException(defaultExceptions[n]);
                    if (exception != null) {
                        exception.setEnabled(true);
                    }
                }
                ++n;
            }
        }
    }

    public String getComponentTag() {
        return null;
    }

    public ExceptionProfiler getProfiler() {
        return this.m_profiler;
    }

    public NotificationSystem getNotificationSystem() {
        return this.m_notificationSystem;
    }
}

