/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import com.jrockit.mc.console.ui.profiler.common.AbstractTemplate;
import com.jrockit.mc.console.ui.profiler.common.Messages;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.TemplateContainer;
import com.jrockit.mc.console.ui.profiler.common.TemplateContentProvider;
import com.jrockit.mc.console.ui.profiler.common.TemplateLabelProvider;
import com.jrockit.mc.console.ui.profiler.common.XMLEntryValidator;
import com.jrockit.mc.console.ui.sections.ConsoleSectionPart;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TemplatesPart
extends ConsoleSectionPart
implements NotificationSystem.ModelListener,
DisposeListener {
    protected final TemplateContainer m_templateContainer;
    protected CheckboxTableViewer m_viewer;
    private Button m_addButton;
    private Button m_editButton;
    private Button m_deleteButton;
    private NotificationSystem m_notificationSystem;

    public TemplatesPart(Composite parent, FormToolkit toolkit, NotificationSystem notificationSystem, TemplateContainer container) {
        super(parent, toolkit, 450);
        this.m_templateContainer = container;
        this.getSection().addDisposeListener((DisposeListener)this);
        this.m_notificationSystem = notificationSystem;
        notificationSystem.addListener(this);
        this.getSection().setText(Messages.TemplatesPart_SECTION_TEXT);
        this.getSection().setDescription(Messages.TemplatesPart_SECTION_DESCRIPTION);
        this.getSection().setExpanded(true);
        Composite client = this.createClient(this.getSection(), this.getFormToolkit());
        this.getSection().setClient((Control)client);
        this.refreshPart(false);
    }

    protected Composite createClient(Section section, FormToolkit toolkit) {
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 6;
        client.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1810);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = 200;
        Composite attributes = this.createTable(client, toolkit);
        attributes.setLayoutData((Object)gd);
        return client;
    }

    public void selectFirstElement() {
        int i = 0;
        while (i < this.m_viewer.getTable().getItemCount()) {
            Object element = this.m_viewer.getElementAt(i);
            if (element instanceof AbstractTemplate && ((AbstractTemplate)element).getEnabled()) {
                this.setSelection(element);
                return;
            }
            ++i;
        }
        this.setSelection(this.m_viewer.getElementAt(0));
    }

    private void setSelection(Object element) {
        if (element != null) {
            StructuredSelection s = new StructuredSelection(new Object[]{element});
            this.m_viewer.setSelection((ISelection)s, true);
        }
    }

    private Composite createTable(Composite client, FormToolkit toolkit) {
        Composite tableContainer = client;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        tableContainer.setLayout((Layout)layout);
        GridData gd = null;
        gd = new GridData(1810);
        Table table = toolkit.createTable(tableContainer, 8454946);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gd);
        this.m_viewer = new CheckboxTableViewer(table);
        this.m_viewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.m_viewer.setSorter(new ViewerSorter());
        this.m_viewer.setUseHashlookup(true);
        this.m_viewer.setInput((Object)this.m_templateContainer);
        this.m_viewer.setCheckedElements(this.m_templateContainer.getProfiledTemplates());
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TemplatesPart.this.m_deleteButton.setEnabled(!TemplatesPart.this.m_viewer.getSelection().isEmpty());
                TemplatesPart.this.m_editButton.setEnabled(!TemplatesPart.this.m_viewer.getSelection().isEmpty());
                IManagedForm managedform = TemplatesPart.this.getManagedForm();
                if (managedform != null) {
                    managedform.fireSelectionChanged((IFormPart)TemplatesPart.this, event.getSelection());
                }
            }
        });
        this.m_viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object object = event.getElement();
                if (object instanceof AbstractTemplate) {
                    TemplatesPart.this.onCheckChange((AbstractTemplate)object, event.getChecked());
                }
            }
        });
        gd = new GridData(2);
        Composite buttonContainer = this.createButtons(toolkit, tableContainer);
        buttonContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(tableContainer);
        return client;
    }

    void onCheckChange(AbstractTemplate template, boolean value) {
        this.getTemplateContainer().enableTemplate(template, value);
    }

    TemplateContainer getTemplateContainer() {
        return this.m_templateContainer;
    }

    private Composite createButtons(FormToolkit toolkit, Composite client) {
        Composite buttonContainer = toolkit.createComposite(client, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.createAddButton(toolkit, buttonContainer);
        this.createEditButton(toolkit, buttonContainer);
        this.createDeleteButton(toolkit, buttonContainer);
        return buttonContainer;
    }

    private void createAddButton(FormToolkit toolkit, Composite buttonContainer) {
        GridData gd = new GridData(4, 1, true, false);
        this.m_addButton = toolkit.createButton(buttonContainer, Messages.TemplatesPart_BUTTON_ADD_TEXT, 8);
        this.m_addButton.setLayoutData((Object)gd);
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name;
                String result = null;
                InputDialog dlg = new InputDialog(this, Display.getCurrent().getActiveShell(), Messages.TemplatesPart_DIALOG_ADD_TEMPLATE_TITLE, Messages.TemplatesPart_DIALOG_ADD_TEMPLATE_TEXT, Messages.TemplatesPart_DIALOG_ADD_TEMPLATE_DEFAULT_VALUE, new XMLEntryValidator()){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                    }

                    public void okPressed() {
                        boolean templateExists;
                        boolean bl = templateExists = 3.access$0(this.this$1).getTemplateContainer().getTemplate(this.getValue()) != null;
                        if (templateExists && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.TemplatesPart_DIALOG_TITLE_TEMPLATE_EXISTS_TEXT, (String)Messages.TemplatesPart_DIALOG_MESSAGE_CONFIRM_TEMPLATE_OVERWRITE_TEXT)) {
                            return;
                        }
                        super.okPressed();
                    }
                };
                if (dlg.open() == 0) {
                    result = dlg.getValue();
                }
                if ((name = result) != null) {
                    AbstractTemplate template = TemplatesPart.this.getTemplateContainer().createTemplate(name);
                    TemplatesPart.this.getTemplateContainer().addTemplate(template);
                    TemplatesPart.this.selectTemplate(template);
                }
            }

            static /* synthetic */ TemplatesPart access$0(3 var0) {
                return var0.TemplatesPart.this;
            }
        });
    }

    private void createEditButton(FormToolkit toolkit, Composite buttonContainer) {
        this.m_editButton = toolkit.createButton(buttonContainer, Messages.TemplatesPart_BUTTON_EDIT_TEXT, 8);
        GridData gd = new GridData(4, 1, true, false);
        this.m_editButton.setLayoutData((Object)gd);
        this.m_editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTemplate abstractTemplate = TemplatesPart.this.getSelectedTemplate();
                if (abstractTemplate != null) {
                    String oldName = abstractTemplate.getName();
                    String newName = TemplatesPart.this.showDialog(abstractTemplate.getName(), Messages.TemplatesPart_EDIT_TEMPLATE_TEXT, Messages.TemplatesPart_EDIT_TEMPLATE_TEXTENTER_NAME_TEXT);
                    if (newName != null) {
                        TemplatesPart.this.getTemplateContainer().rename(oldName, newName);
                    }
                }
            }
        });
    }

    private void createDeleteButton(FormToolkit toolkit, Composite buttonContainer) {
        this.m_deleteButton = toolkit.createButton(buttonContainer, Messages.TemplatesPart_BUTTON_DELETE_TEXT, 8);
        GridData gd = new GridData(4, 1, true, false);
        this.m_deleteButton.setLayoutData((Object)gd);
        this.m_deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTemplate at = TemplatesPart.this.getSelectedTemplate();
                if (at != null) {
                    TemplatesPart.this.getTemplateContainer().removeTemplate(at);
                }
                TemplatesPart.this.selectFirstElement();
            }
        });
    }

    public AbstractTemplate getSelectedTemplate() {
        IStructuredSelection s = (IStructuredSelection)this.m_viewer.getSelection();
        Object o = s.getFirstElement();
        if (o instanceof AbstractTemplate) {
            return (AbstractTemplate)o;
        }
        return null;
    }

    public boolean isDirty() {
        return this.getTemplateContainer().isDirty();
    }

    protected void initializePart() {
        super.initializePart();
        this.selectFirstElement();
    }

    public void selectTemplate(AbstractTemplate template) {
        if (template != null) {
            StructuredSelection s = new StructuredSelection(new Object[]{template});
            this.m_viewer.setSelection((ISelection)s, true);
        }
    }

    public void refreshPart(boolean viewer) {
        this.m_deleteButton.setEnabled(this.getSelectedTemplate() != null);
        this.m_editButton.setEnabled(this.getSelectedTemplate() != null);
        if (viewer) {
            this.m_viewer.refresh();
        }
    }

    protected String showDialog(String initialValue, String title, String text) {
        String result = null;
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), title, text, initialValue, (IInputValidator)new XMLEntryValidator());
        if (dlg.open() == 0) {
            result = dlg.getValue();
        }
        return result;
    }

    public void setEnabled(boolean enabled) {
        this.setButtonEnabled(this.m_deleteButton, enabled);
        this.setButtonEnabled(this.m_addButton, enabled);
        this.setButtonEnabled(this.m_editButton, enabled);
        Section section = this.getSection();
        section.setEnabled(enabled);
        section.update();
    }

    public void setButtonEnabled(Button button, boolean enabled) {
        button.setEnabled(enabled);
    }

    public void onEvent(String event, Object eventData) {
        if ("Template model has changed".equals(event)) {
            this.refreshPart(true);
        }
        if ("Profiling has now stopped".equals(event)) {
            this.setEnabled(true);
        }
        if ("Profiling has now started".equals(event)) {
            this.setEnabled(false);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.m_notificationSystem.removeListener(this);
    }
}

