/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.profiler.common.AbstractTemplate;
import com.jrockit.mc.console.ui.profiler.common.Messages;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TemplateContainer
implements XmlEnabled {
    protected HashMap m_templates = new HashMap();
    protected NotificationSystem m_notificationSystem;
    protected AbstractTemplate m_prototype;
    boolean m_dirty = false;
    static boolean global;

    public TemplateContainer(NotificationSystem notifacationSystem, AbstractTemplate prototype) {
        this.m_notificationSystem = notifacationSystem;
        this.m_prototype = prototype;
    }

    public Collection getTemplates() {
        return this.m_templates.values();
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public AbstractTemplate createTemplate(String name) {
        AbstractTemplate shallowCopy = (AbstractTemplate)this.m_prototype.clone();
        shallowCopy.setName(name);
        return shallowCopy;
    }

    public AbstractTemplate getTemplate(String name) {
        return (AbstractTemplate)this.m_templates.get(name);
    }

    public void addTemplate(AbstractTemplate mpt) {
        this.m_templates.put(mpt.getName(), mpt);
        this.m_dirty = true;
        this.m_notificationSystem.sendEvent("Template model has changed");
    }

    public void removeTemplate(AbstractTemplate mpt) {
        this.m_templates.remove(mpt.getName());
        this.m_dirty = true;
        this.m_notificationSystem.sendEvent("Template model has changed");
    }

    public void rename(String oldName, String newName) {
        Object object = this.m_templates.remove(oldName);
        if (object instanceof AbstractTemplate) {
            AbstractTemplate t = (AbstractTemplate)object;
            t.setName(newName);
            this.addTemplate(t);
            this.m_notificationSystem.sendEvent("Template model has changed");
        }
    }

    public static boolean isGlobal(Element node) {
        return global;
    }

    public static void setGlobal(Element node, boolean globalValue) {
        global = globalValue;
    }

    public Object[] getProfiledTemplates() {
        ArrayList<AbstractTemplate> profiledTemplateList = new ArrayList<AbstractTemplate>();
        Iterator iter = this.m_templates.values().iterator();
        while (iter.hasNext()) {
            AbstractTemplate t = (AbstractTemplate)iter.next();
            if (!t.getEnabled()) continue;
            profiledTemplateList.add(t);
        }
        return profiledTemplateList.toArray();
    }

    public void enableTemplate(AbstractTemplate template, boolean value) {
        template.setEnabled(value);
        this.m_notificationSystem.sendEvent("Template model has changed");
        this.m_dirty = true;
    }

    public void initializeFromXml(Element node) {
        NodeList templateListType = TemplateContainer.isGlobal(node) ? node.getElementsByTagName("availabletemplates") : node.getElementsByTagName("usedtemplates");
        int j = 0;
        while (j < templateListType.getLength()) {
            Element typeNode = (Element)templateListType.item(j);
            NodeList templateList = typeNode.getElementsByTagName("template");
            int i = 0;
            while (i < templateList.getLength()) {
                try {
                    if (TemplateContainer.isGlobal(node)) {
                        AbstractTemplate template = this.createTemplate(Messages.TemplateContainer_UNKNOWN_TEMPLATE_NAME);
                        template.initializeFromXml((Element)templateList.item(i));
                        this.addTemplate(template);
                    } else {
                        AbstractTemplate prototype = this.createTemplate(Messages.TemplateContainer_UNKNOWN_TEMPLATE_NAME);
                        prototype.initializeFromXml((Element)templateList.item(i));
                        AbstractTemplate actual = this.getTemplate(prototype.getName());
                        if (actual != null) {
                            actual.initializeFromXml((Element)templateList.item(i));
                        }
                    }
                }
                catch (Exception e) {
                    ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not load profiling templates", e);
                }
                ++i;
            }
            ++j;
        }
    }

    public void exportToXml(Element node) {
        Iterator iter = this.m_templates.values().iterator();
        Element childNode = TemplateContainer.isGlobal(node) ? XmlToolkit.createElement((Element)node, (String)"availabletemplates") : XmlToolkit.createElement((Element)node, (String)"usedtemplates");
        while (iter.hasNext()) {
            Element templateElement = XmlToolkit.createElement((Element)childNode, (String)"template");
            ((AbstractTemplate)iter.next()).exportToXml(templateElement);
        }
    }

    public String getComponentTag() {
        return null;
    }
}

