/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import com.jrockit.mc.console.ui.profiler.common.Messages;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.SelectionListenerAction;
import com.jrockit.mc.core.CorePlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class StopProfileAction
extends SelectionListenerAction
implements NotificationSystem.ModelListener {
    private NotificationSystem m_notificationSystem;

    public StopProfileAction(NotificationSystem notificationSystem) {
        this.m_notificationSystem = notificationSystem;
        this.m_notificationSystem.addListener(this);
        IPreferenceStore corePreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        boolean buttonsAsText = corePreferenceStore.getBoolean("accessibility.buttonsAsText");
        if (buttonsAsText) {
            this.setText(Messages.StopProfileAction_ACTION_STOP_PROFILING_TEXT);
        } else {
            this.setText("");
        }
        this.setToolTipText(Messages.StopProfileAction_ACTION_STOP_PROFILING_TOOLTIP);
        this.setEnabled(false);
    }

    public void run() {
        this.m_notificationSystem.sendEvent("Stop profiling!");
    }

    public void onEvent(String event, Object eventData) {
        if ("Profiling has now started".equals(event)) {
            this.setEnabled(true);
        }
        if ("Profiling has now stopped".equals(event)) {
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("stop.gif"));
        } else {
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("stopgrey.gif"));
        }
    }

    public void dispose() {
        this.m_notificationSystem.removeListener(this);
        super.dispose();
    }
}

