/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import com.jrockit.mc.console.ui.profiler.common.Messages;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.SelectionListenerAction;
import com.jrockit.mc.core.CorePlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class StartProfileAction
extends SelectionListenerAction
implements NotificationSystem.ModelListener {
    private NotificationSystem m_notificationSystem;

    public StartProfileAction(NotificationSystem notificationSystem) {
        this.m_notificationSystem = notificationSystem;
        this.m_notificationSystem.addListener(this);
        IPreferenceStore corePreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        boolean buttonsAsText = corePreferenceStore.getBoolean("accessibility.buttonsAsText");
        if (buttonsAsText) {
            this.setText(Messages.StartProfileAction_ACTION_START_PROFILING_TEXT);
        } else {
            this.setText("");
        }
        this.setToolTipText(Messages.StartProfileAction_ACTION_START_PROFILING_TOOLTIP);
        this.setEnabled(true);
    }

    public void run() {
        this.m_notificationSystem.sendEvent("Start profiling!");
    }

    public void onEvent(String event, Object eventData) {
        if ("Profiling has now started".equals(event)) {
            this.setEnabled(false);
        }
        if ("Profiling has now stopped".equals(event)) {
            this.setEnabled(true);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("play.gif"));
        } else {
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("playgrey.gif"));
        }
    }

    public void dispose() {
        this.m_notificationSystem.removeListener(this);
        super.dispose();
    }
}

