/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import com.jrockit.mc.console.ui.profiler.common.Messages;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.StartProfileAction;
import com.jrockit.mc.console.ui.profiler.common.StopProfileAction;
import com.jrockit.mc.console.ui.sections.ConsoleSectionPart;
import com.jrockit.mc.core.accessibility.AccessibilityToolkit;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ProfilingControlPart
extends ConsoleSectionPart
implements NotificationSystem.ModelListener {
    private final NotificationSystem m_notificationSystem;
    private Button startButton;
    private Button stopButton;
    private ProgressIndicator m_progressBar;

    public ProfilingControlPart(Composite parent, FormToolkit toolkit, NotificationSystem notificationSystem) {
        super(parent, toolkit, 322);
        this.m_notificationSystem = notificationSystem;
        this.m_notificationSystem.addListener(this);
        this.getSection().setText(Messages.ProfilingControlPart_SECTION_TEXT);
        this.getSection().setExpanded(true);
        Composite client = this.createClient(this.getSection(), this.getFormToolkit());
        this.getSection().setClient((Control)client);
    }

    protected NotificationSystem getNotificationSystem() {
        return this.m_notificationSystem;
    }

    protected Composite createClient(Section section, FormToolkit toolkit) {
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        client.setLayout((Layout)gridLayout);
        GridData gd = new GridData(34);
        Composite buttonContainer = this.createButtons(toolkit, client);
        buttonContainer.setLayoutData((Object)gd);
        return client;
    }

    protected Composite createButtons(FormToolkit toolkit, Composite client) {
        Composite buttonContainer = toolkit.createComposite(client, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        buttonContainer.setLayout((Layout)layout);
        GridData gd = new GridData(36);
        this.startButton = this.createStartButton(toolkit, buttonContainer);
        this.startButton.setLayoutData((Object)gd);
        gd = new GridData(36);
        this.stopButton = this.createStopButton(toolkit, buttonContainer);
        this.stopButton.setLayoutData((Object)gd);
        gd = new GridData(36);
        this.m_progressBar = new ProgressIndicator(buttonContainer);
        this.m_progressBar.setLayoutData((Object)gd);
        return buttonContainer;
    }

    protected Button createStartButton(FormToolkit toolkit, Composite buttonContainer) {
        StartProfileAction startProfileAction = new StartProfileAction(this.m_notificationSystem);
        this.startButton = toolkit.createButton(buttonContainer, startProfileAction.getText(), 8);
        startProfileAction.setButton(this.startButton);
        AccessibilityToolkit.makeAccessibleFromTooltip((Control)this.startButton);
        return this.startButton;
    }

    protected Button createStopButton(FormToolkit toolkit, Composite buttonContainer) {
        StopProfileAction stopProfileAction = new StopProfileAction(this.m_notificationSystem);
        this.stopButton = toolkit.createButton(buttonContainer, stopProfileAction.getText(), 8);
        stopProfileAction.setButton(this.stopButton);
        AccessibilityToolkit.makeAccessibleFromTooltip((Control)this.stopButton);
        return this.stopButton;
    }

    public void onEvent(String event, Object eventData) {
        if (("Profiling has now started".equals(event) || "No Connection".equals(event)) && !this.m_progressBar.isDisposed()) {
            this.m_progressBar.beginAnimatedTask();
        }
        if ("Profiling has now stopped".equals(event) && !this.m_progressBar.isDisposed()) {
            this.m_progressBar.done();
        }
    }
}

