/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import com.jrockit.mc.console.ui.profiler.common.Profiler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ProfilerProgress
implements IRunnableWithProgress {
    private Profiler m_profiler;
    private String m_name;
    private boolean m_enable;

    public ProfilerProgress(Profiler profiler, boolean enable, String name) {
        this.m_profiler = profiler;
        this.m_name = name;
        this.m_enable = enable;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Collection collection = this.m_profiler.getEnabledObjects();
        monitor.beginTask(this.m_name, collection.size());
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            try {
                if (object == null) continue;
                monitor.subTask(object.toString());
                this.m_profiler.enableProfiling(object, this.m_enable);
                monitor.worked(1);
            }
            catch (IOException e) {
                monitor.setCanceled(true);
            }
        }
    }
}

