/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import com.jrockit.mc.console.ui.profiler.ProfilerPlugin;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;

public abstract class Profiler
implements Runnable {
    protected Thread m_pollingThread;
    volatile int m_pollingInterval = 1000;
    protected volatile NotificationSystem m_notificationSystem;
    volatile boolean m_kill = false;
    private Object m_syncObject = new Object();
    private boolean m_keepAlive = true;

    public Profiler(NotificationSystem notificationSystem) {
        this.m_notificationSystem = notificationSystem;
    }

    public abstract void reset();

    protected abstract boolean enableProfiling(Object var1, boolean var2) throws IOException;

    protected abstract boolean profile(Object var1) throws IOException;

    public abstract Collection getEnabledObjects();

    public void setPollingInterval(int ms) {
        this.m_pollingInterval = ms;
    }

    public long getPollingInterval() {
        return this.m_pollingInterval;
    }

    public boolean isProfiling() {
        return this.m_pollingThread != null && this.m_pollingThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startProfiling() {
        if (this.isProfiling()) {
            return false;
        }
        Object object = this.m_syncObject;
        synchronized (object) {
            this.m_keepAlive = true;
        }
        this.m_pollingThread = new Thread(this);
        this.m_pollingThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopProfiling() {
        if (!this.isProfiling()) {
            return false;
        }
        Object object = this.m_syncObject;
        synchronized (object) {
            this.m_keepAlive = false;
            this.m_syncObject.notify();
        }
        this.m_pollingThread = null;
        return true;
    }

    protected boolean enableProfiling(boolean enable) throws IOException {
        Iterator iter = this.getEnabledObjects().iterator();
        boolean dirty = false;
        while (iter.hasNext() && this.isRunning()) {
            Object object = iter.next();
            if (object == null || !this.enableProfiling(object, enable)) continue;
            dirty = true;
        }
        return dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRunning() {
        Object object = this.m_syncObject;
        synchronized (object) {
            return this.m_keepAlive;
        }
    }

    public boolean profile() throws IOException {
        Iterator iter = this.getEnabledObjects().iterator();
        boolean dirty = false;
        while (iter.hasNext() && this.isRunning()) {
            Object object = iter.next();
            if (object == null || !this.profile(object)) continue;
            dirty = true;
        }
        if (dirty && this.isRunning()) {
            this.m_notificationSystem.sendEvent("New profiling data is available");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                Object object = this.m_syncObject;
                synchronized (object) {
                    if (!this.m_keepAlive) {
                        break;
                    }
                }
                if (this.profile()) {
                    try {
                        object = this.m_syncObject;
                        synchronized (object) {
                            this.m_syncObject.wait(this.getPollingInterval());
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            ProfilerPlugin.getDefault().getLogger().log(Level.WARNING, "Could not establish connection when trying to profile.", e);
            this.m_notificationSystem.sendEvent("No Connection");
        }
    }
}

