/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.profiler.ProfilerPlugin;
import com.jrockit.mc.console.ui.profiler.common.Messages;
import com.jrockit.mc.console.ui.profiler.common.NotificationSystem;
import com.jrockit.mc.console.ui.profiler.common.Profiler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProfileMonitor
implements IRunnableWithProgress,
IPropertyChangeListener,
NotificationSystem.ModelListener {
    private volatile Profiler m_profiler;
    private volatile boolean m_enabled;
    private volatile String m_name;
    private volatile NotificationSystem m_notificationSystem;

    public ProfileMonitor(NotificationSystem notificationSystem, Profiler profiler) {
        this.m_profiler = profiler;
        this.m_notificationSystem = notificationSystem;
        this.m_notificationSystem.addListener(this);
        this.setUpdateInterval();
        ConsolePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void onEvent(String event, Object eventData) {
        if ("Start profiling!".equals(event)) {
            this.start();
        }
        if ("Stop profiling!".equals(event)) {
            this.stop();
        }
        if ("No Connection".equals(event)) {
            this.noConnection();
        }
    }

    private void noConnection() {
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            String message = Messages.ProfileMonitor_CONNECTION_BROKEN_DURING_PROFILING_TEXT;
            MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.ProfileMonitor_CONNECTION_BROKEN_TITLE, (String)message);
        }
    }

    private void setUpdateInterval() {
        int value = ConsolePlugin.getDefault().getPreferenceStore().getInt("console.ui.profiling.update.interval.");
        this.getProfiler().setPollingInterval(value);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object value;
        if (event.getProperty().equals("console.ui.profiling.update.interval.") && (value = event.getNewValue()) instanceof Integer) {
            this.getProfiler().setPollingInterval((Integer)value);
        }
    }

    public void shutDown() {
        ConsolePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.getNotificationSystem().removeAllListeners();
        if (this.getProfiler().isRunning()) {
            this.stop();
        }
    }

    private void stop() {
        if (this.getProfiler().stopProfiling()) {
            this.progressStop();
        }
    }

    private void progressStop() {
        this.setProfilingEnabled(false);
        try {
            this.setCurrenTaskName(Messages.ProfileMonitor_DISABLE_PROFILING_FOR_METHOD);
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e) {
            ProfilerPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when stopping profiler when using progress service", e);
        }
        catch (InterruptedException e) {
            ProfilerPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when stopping profiler when using progress service", e);
        }
        this.getNotificationSystem().sendEvent("Profiling has now stopped");
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Collection collection = this.getProfiler().getEnabledObjects();
        monitor.beginTask("", collection.size());
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            try {
                if (object == null) continue;
                monitor.subTask(MessageFormat.format(this.getCurrentTaskName(), object.toString()));
                this.getProfiler().enableProfiling(object, this.isProfilingEnabled());
                monitor.worked(1);
            }
            catch (IOException e) {
                monitor.setCanceled(true);
                ProfilerPlugin.getDefault().getLogger().log(Level.SEVERE, "Error when setting profiler =" + this.isProfilingEnabled() + " for " + object, e);
            }
        }
    }

    public void start() {
        if (!this.getProfiler().isProfiling()) {
            this.getProfiler().reset();
            this.getNotificationSystem().sendEvent("New profiling data is available");
            this.setProfilingEnabled(true);
            try {
                this.setCurrenTaskName(Messages.ProfileMonitor_ENABLE_PROFILING_FOR_METHOD);
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)this);
                this.getProfiler().startProfiling();
                this.getNotificationSystem().sendEvent("Profiling has now started");
                return;
            }
            catch (InvocationTargetException e) {
                ProfilerPlugin.getDefault().getLogger().log(Level.SEVERE, "Error starting progress monitor for profiler.", e);
            }
            catch (InterruptedException e) {
                ProfilerPlugin.getDefault().getLogger().log(Level.SEVERE, "Error starting progress monitor for profiler.", e);
            }
            this.progressStop();
        }
    }

    public void setCurrenTaskName(String name) {
        this.m_name = name;
    }

    public String getCurrentTaskName() {
        return this.m_name;
    }

    public void setProfilingEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean isProfilingEnabled() {
        return this.m_enabled;
    }

    protected Profiler getProfiler() {
        return this.m_profiler;
    }

    protected NotificationSystem getNotificationSystem() {
        return this.m_notificationSystem;
    }
}

