/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;

public class NotificationSystem {
    protected ArrayList m_listeners = new ArrayList();

    private synchronized void sendToAll(String message, Object eventData) {
        Iterator listIterator = this.m_listeners.iterator();
        while (listIterator.hasNext()) {
            ModelListener l = (ModelListener)listIterator.next();
            l.onEvent(message, eventData);
        }
    }

    public void sendEvent(String message) {
        this.sendEvent(message, null);
    }

    public synchronized void removeAllListeners() {
        this.m_listeners.clear();
    }

    public void sendEvent(final String message, final Object eventData) {
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    NotificationSystem.this.sendToAll(message, eventData);
                }
            });
        } else {
            this.sendToAll(message, eventData);
        }
    }

    public synchronized void addListener(ModelListener listener) {
        this.m_listeners.add(listener);
    }

    public synchronized void removeListener(ModelListener listener) {
        this.m_listeners.remove(listener);
    }

    public static interface ModelListener {
        public void onEvent(String var1, Object var2);
    }
}

