/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.profiler.common;

import java.text.ParseException;
import org.eclipse.jface.viewers.LabelProvider;

public class HumanReadableMethodLabelProvider
extends LabelProvider {
    public static final char LP = '(';
    public static final char RP = ')';
    public static final char LB = '[';
    public static final char RB = ']';
    public static final char CLASS_SUFFIX = ';';
    public static final char CLASS_PREFIX = 'L';
    public static final char PACKAGE_SEPARATOR = '.';
    public static final String COMMA_SEPARATOR = ", ";
    public static final String ARRAY = "[]";

    public String getReturnType(String descriptor, boolean qualified) throws Exception {
        StringBuffer output = new StringBuffer();
        this.parseToken(output, descriptor.substring(descriptor.indexOf(41) + 1), 0, qualified);
        return output.toString();
    }

    public String getParameters(String descriptor, boolean qualified) throws Exception {
        String input = descriptor.substring(descriptor.indexOf(40) + 1, descriptor.lastIndexOf(41));
        StringBuffer output = new StringBuffer(Character.toString('('));
        int next = -1;
        int current = 0;
        while (current < input.length()) {
            next = this.parseToken(output, input, current, qualified);
            if (next == current) break;
            if (next < input.length()) {
                output.append(COMMA_SEPARATOR);
            }
            current = next;
        }
        return output.append(')').toString();
    }

    private int parseToken(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        if (input.charAt(position) == '[') {
            return this.readArray(output, input, position, qualified);
        }
        if (input.charAt(position) == 'L') {
            return this.readComponentType(output, input, position, qualified);
        }
        return this.readPrimitive(output, input, position, qualified);
    }

    private int readArray(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        return this.write(output, ARRAY, this.parseToken(output, input, position + 1, qualified));
    }

    private int readPrimitive(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        return this.write(output, this.getPrimitiveType(input.charAt(position)), position + 1);
    }

    private int write(StringBuffer output, String string, int next_position) {
        output.append(string);
        return next_position;
    }

    private int readComponentType(StringBuffer output, String input, int position, boolean qualified) {
        int endIndex = input.indexOf(59, position);
        return this.write(output, this.getClass(input.substring(position + 1, endIndex), qualified), endIndex + 1);
    }

    private String getClass(String clazz, boolean qualified) {
        return qualified ? clazz : clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    private String getPrimitiveType(char ch) throws Exception {
        if (ch == 'Z') {
            return Boolean.TYPE.toString();
        }
        if (ch == 'B') {
            return Byte.TYPE.toString();
        }
        if (ch == 'S') {
            return Short.TYPE.toString();
        }
        if (ch == 'I') {
            return Integer.TYPE.toString();
        }
        if (ch == 'C') {
            return Character.TYPE.toString();
        }
        if (ch == 'J') {
            return Long.TYPE.toString();
        }
        if (ch == 'F') {
            return Float.TYPE.toString();
        }
        if (ch == 'D') {
            return Double.TYPE.toString();
        }
        if (ch == 'V') {
            return Void.TYPE.toString();
        }
        throw new ParseException("Character " + ch + " does not represent a primitive type.", -1);
    }
}

