/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.jdp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class ClientJDPPacket {
    public static final String KEY_VERSION = "version";
    private static final char DELIMITER = '!';
    private String m_address;
    private int m_port = 0;
    private Map m_extendedInfo = new HashMap();
    private String m_name;
    private int m_supportsJMX = -1;
    private static final int JMXSUPPORTUNKNOWN = -1;
    private static final int JMXSUPPORTED = 1;
    public static final int DEFAULT_PORT = 7095;
    public static final String DEFAULT_ADDRESS = "232.192.1.212";

    public ClientJDPPacket(byte[] bytes) {
        this.decode(bytes);
    }

    public ClientJDPPacket(String address, int port) {
        this.m_address = address;
        this.m_port = port;
    }

    public ClientJDPPacket(String address, int port, String extendedInfo, boolean supportsJMX) {
        this(address, port);
        this.decodeExtendedInfo(extendedInfo);
        this.m_supportsJMX = supportsJMX ? 1 : 0;
    }

    public ClientJDPPacket(String name, String address, int port, String version, boolean supportsJMX) {
        this(address, port, version, supportsJMX);
        if (name != null && name.indexOf(33) >= 0) {
            throw new IllegalArgumentException("The name must not include !");
        }
        this.m_name = name;
    }

    public void decode(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        String payload = null;
        try {
            payload = dis.readUTF();
            StringTokenizer strTok = new StringTokenizer(payload, String.valueOf('!'), false);
            int totalTokens = strTok.countTokens();
            if (totalTokens >= 4) {
                this.decodeExtendedInfo(strTok.nextToken());
                this.setSupportsJMX(Integer.parseInt(strTok.nextToken()));
                this.setAddress(strTok.nextToken());
                this.setPort(Integer.parseInt(strTok.nextToken()));
                if (totalTokens >= 5) {
                    this.setName(strTok.nextToken());
                }
            } else {
                this.setAddress(strTok.nextToken());
                try {
                    this.setPort(Integer.parseInt(strTok.nextToken()));
                }
                catch (NumberFormatException nfe) {
                    this.setPort(0);
                }
            }
        }
        catch (Exception e) {
            this.m_supportsJMX = -1;
            this.m_address = null;
            this.m_port = 0;
            this.m_extendedInfo = null;
            return;
        }
    }

    public byte[] encode() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (!this.isComplete()) {
            return null;
        }
        try {
            String packet = "";
            if (this.m_supportsJMX != -1) {
                packet = String.valueOf('!') + this.encodeExtendedInfo() + '!' + this.m_supportsJMX;
            }
            packet = String.valueOf(packet) + '!' + this.getAddress() + '!' + String.valueOf(this.getPort());
            if (this.m_name != null && !"".equals(this.m_name)) {
                packet = String.valueOf(packet) + '!' + this.m_name;
            }
            dos.writeUTF(packet);
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        return bos.toByteArray();
    }

    public String getAddress() {
        return this.m_address;
    }

    public boolean supportsJMX() throws UnsupportedOperationException {
        if (this.m_supportsJMX == -1) {
            throw new UnsupportedOperationException("Information about JMX support is not available in packet.");
        }
        return this.m_supportsJMX == 1;
    }

    public int getPort() {
        return this.m_port;
    }

    private void setAddress(String address) {
        this.m_address = address;
    }

    private void setSupportsJMX(int supportsJMX) {
        this.m_supportsJMX = supportsJMX;
    }

    private void setPort(int port) {
        this.m_port = port;
    }

    public String getVersion() throws UnsupportedOperationException {
        if (!this.m_extendedInfo.containsKey(KEY_VERSION)) {
            throw new UnsupportedOperationException("Version information not available in packet.");
        }
        return (String)this.m_extendedInfo.get(KEY_VERSION);
    }

    public boolean isComplete() {
        return this.m_address != null && this.m_port != 0;
    }

    public String toString() {
        String jmx = "unknown";
        String version = "unknown";
        if (this.m_supportsJMX != -1) {
            String string = jmx = this.m_supportsJMX == 1 ? "available" : "not available";
        }
        if (this.m_extendedInfo.containsKey(KEY_VERSION)) {
            version = this.getVersion();
        }
        return "JDPPacket - ManagementServer running version " + version + " exist at " + this.getAddress() + ":" + this.getPort() + " with support for JMX " + jmx;
    }

    public String getCanonicalName() {
        return String.valueOf(this.getAddress()) + ":" + this.getPort();
    }

    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        try {
            return this.getCanonicalName().equals(((ClientJDPPacket)arg).getCanonicalName());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.getCanonicalName().hashCode();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    private void decodeExtendedInfo(String extendedInfo) {
        String[] info = extendedInfo.split(",");
        if (info == null) {
            return;
        }
        if (info.length == 1 && extendedInfo.indexOf(61) < 0) {
            this.m_extendedInfo.put(KEY_VERSION, extendedInfo);
            return;
        }
        int i = 0;
        while (i < info.length) {
            String[] keyValue = info[i].split("=");
            if (keyValue != null && keyValue.length == 2) {
                this.m_extendedInfo.put(keyValue[0], keyValue[1]);
            }
            ++i;
        }
    }

    private String encodeExtendedInfo() {
        if (this.m_extendedInfo.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.m_extendedInfo.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            buf.append(key);
            buf.append("=");
            buf.append(this.m_extendedInfo.get(key));
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public String getExtendedInfo(String key) {
        return (String)this.m_extendedInfo.get(key);
    }

    public Map getExtendedInfo() {
        return Collections.unmodifiableMap(this.m_extendedInfo);
    }

    public void setExtendedInfo(String key, String value) {
        this.checkCharacters(key);
        this.checkCharacters(value);
        this.m_extendedInfo.put(key, value);
    }

    private void checkCharacters(String key) {
        int i = 0;
        while (i < key.length()) {
            if (key.charAt(i) == '!' || key.charAt(i) == '=' || key.charAt(i) == ',') {
                throw new IllegalArgumentException("Found illegal character " + key.charAt(i));
            }
            ++i;
        }
    }
}

