/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.util;

import com.jrockit.common.util.MalformedDescriptorException;
import com.jrockit.common.util.MethodIdentifier;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class ReflectionToolkit {
    public static final String ENCODING_DELIMITER = "!";

    public static MethodIdentifier[] decodeArrayFromString(String identifierString) throws MalformedDescriptorException {
        StringTokenizer tokenizer = new StringTokenizer(identifierString, ENCODING_DELIMITER, false);
        ArrayList<MethodIdentifier> mList = new ArrayList<MethodIdentifier>();
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            String descriptor = tokenizer.nextToken();
            String methodName = tokenizer.nextToken();
            mList.add(new MethodIdentifier(className, methodName, descriptor));
        }
        MethodIdentifier[] methodArray = new MethodIdentifier[mList.size()];
        int i = 0;
        while (i < methodArray.length) {
            methodArray[i] = (MethodIdentifier)mList.get(i);
            ++i;
        }
        return methodArray;
    }

    public static String encodeArrayToString(MethodIdentifier[] identifiers) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < identifiers.length) {
            result.append(identifiers[i].getClassName());
            result.append(ENCODING_DELIMITER);
            result.append(identifiers[i].getDescriptor().getFormalDescriptor());
            result.append(ENCODING_DELIMITER);
            result.append(identifiers[i].getMethodName());
            if (i < identifiers.length - 1) {
                result.append(ENCODING_DELIMITER);
            }
            ++i;
        }
        return result.toString();
    }
}

