/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.util;

public final class NativeToolkit {
    private NativeToolkit() {
    }

    public static void writeShortToByteArray(short aShort, byte[] array, int position) {
        int i = 0;
        while (i < 2) {
            byte b;
            array[position + 1 - i] = b = (byte)(aShort & 0xFF);
            aShort = (short)(aShort >> 8);
            ++i;
        }
    }

    public static void writeIntToByteArray(int anInt, byte[] array, int position) {
        int i = 0;
        while (i < 4) {
            byte b;
            array[position + 3 - i] = b = (byte)(anInt & 0xFF);
            anInt >>= 8;
            ++i;
        }
    }

    public static void writeLongToByteArray(long aLong, byte[] array, int position) {
        int i = 0;
        while (i < 8) {
            byte b;
            array[position + 7 - i] = b = (byte)(aLong & 0xFFL);
            aLong >>= 8;
            ++i;
        }
    }

    public static void writeDoubleToByteArray(double aDouble, byte[] array, int position) {
        NativeToolkit.writeLongToByteArray(Double.doubleToLongBits(aDouble), array, position);
    }

    public static double getDoubleFromByteArray(byte[] array, int position) {
        return Double.longBitsToDouble(NativeToolkit.getLongFromByteArray(array, position));
    }

    public static long getLongFromByteArray(byte[] array, int position) {
        long result = 0L;
        int i = 0;
        while (i < 8) {
            result <<= 8;
            byte b = array[position + i];
            result |= (long)b & 0xFFL;
            ++i;
        }
        return result;
    }

    public static short getShortFromByteArray(byte[] array, int position) {
        short result = 0;
        int i = 0;
        while (i < 2) {
            result = (short)(result << 8);
            byte b = array[position + i];
            result = (short)(result | (short)b & 0xFF);
            ++i;
        }
        return result;
    }

    public static int getIntFromByteArray(byte[] array, int position) {
        int result = 0;
        int i = 0;
        while (i < 4) {
            result <<= 8;
            byte b = array[position + i];
            result |= b & 0xFF;
            ++i;
        }
        return result;
    }

    public static String encodeBitMaskToString(int[] bitMask) {
        String encodedString = new String();
        int i = 0;
        while (i < bitMask.length) {
            int bit = bitMask[i];
            if (bit != 0 && bit != 1 && bit != 2) {
                throw new RuntimeException("Not a bit mask! Value at position " + i + " is " + bitMask[i]);
            }
            encodedString = String.valueOf(encodedString) + bit;
            ++i;
        }
        return encodedString;
    }

    public static int[] decodeStringToBitMask(String bitMaskString) {
        int[] bitMask = new int[bitMaskString.length()];
        int i = 0;
        while (i < bitMaskString.length()) {
            char bit = bitMaskString.charAt(i);
            if (bit == '0') {
                bitMask[i] = 0;
            } else if (bit == '1') {
                bitMask[i] = 1;
            } else if (bit == '2') {
                bitMask[i] = 2;
            } else {
                throw new RuntimeException("String does not represent bit mask. Character was " + bit);
            }
            ++i;
        }
        return bitMask;
    }
}

