/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.util;

import com.jrockit.common.util.ClassIdentifier;
import com.jrockit.common.util.MalformedDescriptorException;
import com.jrockit.common.util.MethodDescriptor;
import java.lang.reflect.Method;

public class MethodIdentifier {
    private String m_className;
    private String m_methodName;
    private MethodDescriptor m_descriptor;
    public static final String STR_CODING_DELIM = "!";

    public MethodIdentifier() {
    }

    public MethodIdentifier(String className, String methodName, MethodDescriptor descriptor) {
        this.m_className = className;
        this.m_methodName = methodName;
        this.m_descriptor = descriptor;
    }

    public MethodIdentifier(String className, String methodName, String formalDescriptor) throws MalformedDescriptorException {
        this(className, methodName, new MethodDescriptor(formalDescriptor));
    }

    public MethodIdentifier(Method method) {
        this.m_className = method.getDeclaringClass().getName();
        this.m_methodName = method.getName();
        this.m_descriptor = new MethodDescriptor(method);
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getNonQualifiedClassName() {
        return ClassIdentifier.getBaseClassName(this.getClassName());
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public MethodDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public String toString() {
        return this.getHumanReadable();
    }

    public String getHumanReadable() {
        return this.getDescriptor().getHumanReadable(String.valueOf(this.getClassName()) + "." + this.getMethodName());
    }

    public String getNonQualifiedHumanReadable() {
        return this.getDescriptor().getNonQualifiedHumanReadable(String.valueOf(this.getNonQualifiedClassName()) + "." + this.getMethodName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodIdentifier)) {
            return false;
        }
        MethodIdentifier other = (MethodIdentifier)obj;
        return other.getClassName().equals(this.getClassName()) && other.getMethodName().equals(this.getMethodName()) && other.getDescriptor().equals(this.getDescriptor());
    }

    public int hashCode() {
        return this.getClassName().hashCode() | this.getMethodName().hashCode() | this.getDescriptor().hashCode();
    }
}

