/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.util;

import com.jrockit.common.util.DebugPrinter;
import com.jrockit.common.util.MalformedDescriptorException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MethodDescriptor {
    private String m_formalDescriptor;
    private String m_parameters;
    private String m_returnType;
    private transient String m_nonQualifiedReturnType;
    private transient String m_nonQualifiedParameters;

    public MethodDescriptor(String descriptor) throws MalformedDescriptorException {
        this.initializeFromDescriptor(descriptor);
    }

    public MethodDescriptor(Method method) {
        try {
            this.initializeFromDescriptor(MethodDescriptor.createFormalDescriptor(method));
        }
        catch (MalformedDescriptorException ignored) {
            DebugPrinter.exception(ignored);
        }
    }

    public MethodDescriptor(String parameters, String returnType) throws MalformedDescriptorException {
        this.m_formalDescriptor = MethodDescriptor.createFormalDescriptor(parameters, returnType);
        this.initializeFromDescriptor(this.m_formalDescriptor);
    }

    public static String createFormalDescriptor(Method method) {
        StringBuffer s = new StringBuffer("(");
        Class<?>[] parameters = method.getParameterTypes();
        int i = 0;
        while (i < parameters.length) {
            MethodDescriptor.appendDescriptorForClass(parameters[i], s);
            ++i;
        }
        s.append(")");
        MethodDescriptor.appendDescriptorForClass(method.getReturnType(), s);
        return s.toString();
    }

    private void initializeFromDescriptor(String descriptor) throws MalformedDescriptorException {
        this.m_formalDescriptor = descriptor;
        this.initializeFromFormalDescriptor(this.m_formalDescriptor, true);
    }

    private int convertOneVariableToHumanReadable(int position, StringBuffer source, StringBuffer destination, boolean fullyQualified) throws MalformedDescriptorException {
        char ch = source.charAt(position++);
        switch (ch) {
            case 'Z': {
                destination.append("boolean");
                break;
            }
            case 'B': {
                destination.append("byte");
                break;
            }
            case 'S': {
                destination.append("short");
                break;
            }
            case 'I': {
                destination.append("int");
                break;
            }
            case 'C': {
                destination.append("char");
                break;
            }
            case 'J': {
                destination.append("long");
                break;
            }
            case 'F': {
                destination.append("float");
                break;
            }
            case 'D': {
                destination.append("double");
                break;
            }
            case 'V': {
                destination.append("void");
                break;
            }
            case '[': {
                String rest = source.substring(position - 1);
                int index = this.findIndexOfLastConsecutive('[', rest);
                if (rest.charAt(index + 1) == 'L') {
                    destination.append(rest.substring(0, rest.indexOf(59) + 1));
                    position += rest.indexOf(59);
                    break;
                }
                destination.append(rest.substring(0, index + 2));
                position += index + 1;
                break;
            }
            case 'L': {
                int classNameLength = source.substring(position).indexOf(59);
                if (classNameLength == -1) {
                    throw new MalformedDescriptorException("Class name (L) not terminated by ; in descriptor: " + source);
                }
                String fullyQualifiedName = source.substring(position, position + classNameLength);
                position += classNameLength + 1;
                if (fullyQualified) {
                    destination.append(fullyQualifiedName);
                    break;
                }
                destination.append(fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1));
                break;
            }
            default: {
                throw new MalformedDescriptorException("Unknown type designator: " + ch);
            }
        }
        return position;
    }

    private int findIndexOfLastConsecutive(char c, String rest) {
        int i = 0;
        while (i < rest.length()) {
            if (rest.charAt(i) != c) {
                return i - 1;
            }
            ++i;
        }
        return -1;
    }

    private void initializeFromFormalDescriptor(String formalDescriptor, boolean fullyQualified) throws MalformedDescriptorException {
        StringBuffer source = new StringBuffer(formalDescriptor);
        if (source.charAt(0) != '(') {
            throw new MalformedDescriptorException("Descriptor does not begin with '(': " + this.m_formalDescriptor);
        }
        StringBuffer parameters = new StringBuffer();
        int position = 1;
        while (position < source.length() && source.charAt(position) != ')') {
            if (position > 1) {
                parameters.append(",");
            }
            position = this.convertOneVariableToHumanReadable(position, source, parameters, fullyQualified);
        }
        if (position >= source.length()) {
            throw new MalformedDescriptorException("No ')' found in descriptor: " + this.m_formalDescriptor);
        }
        if (fullyQualified) {
            this.m_parameters = parameters.toString();
        } else {
            this.m_nonQualifiedParameters = parameters.toString();
        }
        if (++position >= source.length()) {
            throw new MalformedDescriptorException("No return type found in descriptor: " + this.m_formalDescriptor);
        }
        StringBuffer returnType = new StringBuffer();
        if ((position = this.convertOneVariableToHumanReadable(position, source, returnType, fullyQualified)) != source.length()) {
            throw new MalformedDescriptorException("No more input expected after return type in descriptor: " + this.m_formalDescriptor);
        }
        if (fullyQualified) {
            this.m_returnType = returnType.toString();
        } else {
            this.m_nonQualifiedReturnType = returnType.toString();
        }
    }

    private static String createFormalDescriptor(String parametersStr, String returnType) throws MalformedDescriptorException {
        String[] parameters = parametersStr.split(",");
        StringBuffer descriptor = new StringBuffer();
        descriptor.append("(");
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i].length() != 0) {
                MethodDescriptor.appendDescriptorForString(parameters[i], descriptor);
            }
            ++i;
        }
        descriptor.append(")");
        MethodDescriptor.appendDescriptorForString(returnType, descriptor);
        return descriptor.toString();
    }

    private static void appendDescriptorForClass(Class aClass, StringBuffer s) {
        if (!aClass.isPrimitive()) {
            String className = aClass.getName();
            if (className.charAt(0) == '[') {
                s.append(className);
            } else {
                s.append("L");
                s.append(className);
                s.append(";");
            }
        } else if (aClass == Byte.TYPE) {
            s.append("B");
        } else if (aClass == Short.TYPE) {
            s.append("S");
        } else if (aClass == Character.TYPE) {
            s.append("C");
        } else if (aClass == Integer.TYPE) {
            s.append("I");
        } else if (aClass == Long.TYPE) {
            s.append("J");
        } else if (aClass == Float.TYPE) {
            s.append("F");
        } else if (aClass == Double.TYPE) {
            s.append("D");
        } else if (aClass == Boolean.TYPE) {
            s.append("Z");
        } else if (aClass == Void.TYPE) {
            s.append("V");
        }
    }

    private static void appendDescriptorForString(String type, StringBuffer descriptor) {
        if (type.startsWith("[")) {
            descriptor.append(type);
        } else if (type.equals(Byte.TYPE.toString())) {
            descriptor.append("B");
        } else if (type.equals(Short.TYPE.toString())) {
            descriptor.append("S");
        } else if (type.equals(Character.TYPE.toString())) {
            descriptor.append("C");
        } else if (type.equals(Integer.TYPE.toString())) {
            descriptor.append("I");
        } else if (type.equals(Long.TYPE.toString())) {
            descriptor.append("J");
        } else if (type.equals(Float.TYPE.toString())) {
            descriptor.append("F");
        } else if (type.equals(Double.TYPE.toString())) {
            descriptor.append("D");
        } else if (type.equals(Boolean.TYPE.toString())) {
            descriptor.append("Z");
        } else if (type.equals(Void.TYPE.toString())) {
            descriptor.append("V");
        } else {
            descriptor.append("L");
            descriptor.append(type);
            descriptor.append(";");
        }
    }

    public String getHumanReadable(String methodName) {
        return String.valueOf(this.getReturnType()) + " " + methodName + "(" + this.getParameters() + ")";
    }

    public String getNonQualifiedHumanReadable(String methodName) {
        return String.valueOf(this.getNonQualifiedReturnType()) + " " + methodName + "(" + this.getNonQualifiedParameters() + ")";
    }

    public String getFormalDescriptor() {
        return this.m_formalDescriptor;
    }

    public String getParameters() {
        return this.m_parameters;
    }

    public Class[] getParameterTypes(ClassLoader cl) throws ClassNotFoundException {
        ArrayList<Class> parameters = new ArrayList<Class>();
        StringTokenizer tokenizer = new StringTokenizer(this.getParameters(), ",");
        while (tokenizer.hasMoreTokens()) {
            String parameter = tokenizer.nextToken();
            try {
                Class<?> aClass = Class.forName(parameter, true, cl);
                parameters.add(aClass);
            }
            catch (ClassNotFoundException e) {
                Class primitiveType = this.getPrimitiveParameterType(parameter);
                if (primitiveType != null) {
                    parameters.add(primitiveType);
                    continue;
                }
                throw e;
            }
        }
        Class[] parameterArray = new Class[parameters.size()];
        return parameters.toArray(parameterArray);
    }

    public String getReturnType() {
        return this.m_returnType;
    }

    public String getNonQualifiedParameters() {
        if (this.m_nonQualifiedParameters == null) {
            try {
                this.initializeFromFormalDescriptor(this.m_formalDescriptor, false);
            }
            catch (MalformedDescriptorException e) {
                e.printStackTrace();
            }
        }
        return this.m_nonQualifiedParameters;
    }

    public String getNonQualifiedReturnType() {
        if (this.m_nonQualifiedReturnType == null) {
            try {
                this.initializeFromFormalDescriptor(this.m_formalDescriptor, false);
            }
            catch (MalformedDescriptorException e) {
                e.printStackTrace();
            }
        }
        return this.m_nonQualifiedReturnType;
    }

    public String toString() {
        return this.getHumanReadable("<method>");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)obj;
        return other.getFormalDescriptor().equals(this.getFormalDescriptor());
    }

    public int hashCode() {
        return this.getFormalDescriptor().hashCode();
    }

    private Class getPrimitiveParameterType(String parameter) {
        if (parameter.equals("int")) {
            return Integer.TYPE;
        }
        if (parameter.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (parameter.equals("double")) {
            return Double.TYPE;
        }
        if (parameter.equals("long")) {
            return Long.TYPE;
        }
        if (parameter.equals("float")) {
            return Float.TYPE;
        }
        if (parameter.equals("char")) {
            return Character.TYPE;
        }
        if (parameter.equals("short")) {
            return Short.TYPE;
        }
        if (parameter.equals("byte")) {
            return Byte.TYPE;
        }
        return null;
    }
}

