/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.util;

import com.jrockit.common.util.Print;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public final class DebugPrinter {
    public static final String PROPERTY_KEY_USE_DEBUGGING = "jrockit.managementserver.debug";
    public static final String PROPERTY_KEY_DEBUGGING_MODULES = "jrockit.managementserver.debug.modules";
    public static final String PROPERTY_KEY_DEBUGGING_PRINT_CLASS = "jrockit.managementserver.debug.printclass";
    public static final String PROPERTY_KEY_DEBUGGING_PRINT_MODULE = "jrockit.managementserver.debug.printmodule";
    private static final Set ACTIVE_MODULES = new HashSet();
    public static final boolean USE_DEBUGGING = Boolean.valueOf(System.getProperty("jrockit.managementserver.debug"));
    private static final boolean PRINT_CLASS = Boolean.valueOf(System.getProperty("jrockit.managementserver.debug.printclass", "false"));
    private static final boolean PRINT_MODULE = Boolean.valueOf(System.getProperty("jrockit.managementserver.debug.printmodule", "true"));
    public static final boolean DEBUG;
    private static PrintStream m_out;
    private static PrintStream m_err;
    private static PrintStream m_ignoringPrintStream;

    static {
        if (USE_DEBUGGING) {
            System.out.println("Debug printing is enabled...");
            DebugPrinter.parseModules(System.getProperty(PROPERTY_KEY_DEBUGGING_MODULES));
        }
        boolean bl = DEBUG = USE_DEBUGGING && !Print.QUIET;
        if (DEBUG) {
            m_out = System.out;
            m_err = System.err;
        } else {
            m_out = m_ignoringPrintStream = new PrintStream(new OutputStream(){

                public void write(int b) {
                }
            });
            m_err = m_ignoringPrintStream;
        }
    }

    private DebugPrinter() {
    }

    private static void parseModules(String property) {
        if (property != null && !property.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(property, ",", false);
            System.out.print("Active debug modules : ");
            while (st.hasMoreTokens()) {
                String module = st.nextToken().toUpperCase();
                ACTIVE_MODULES.add(module);
                System.out.print(String.valueOf(module) + " ");
            }
            System.out.print('\n');
            System.out.flush();
        } else {
            System.out.print("No active debug modules. Will only print global debug info.");
        }
    }

    private static String getModulePrefix(String module) {
        return PRINT_MODULE ? "[" + module + "] " : "";
    }

    private static String getClassPrefix(Class c) {
        return PRINT_CLASS ? "[" + DebugPrinter.getClassName(c) + "] " : "";
    }

    public static void println(String s) {
        if (DEBUG) {
            System.out.println(s);
            System.out.flush();
        }
    }

    public static void print(String s) {
        if (DEBUG) {
            System.out.print(s);
            System.out.flush();
        }
    }

    public static void println(Class c, String s) {
        DebugPrinter.println(String.valueOf(DebugPrinter.getClassPrefix(c)) + s);
    }

    public static void println(String module, Class c, String s) {
        if (ACTIVE_MODULES.contains(module)) {
            DebugPrinter.println(c, String.valueOf(DebugPrinter.getModulePrefix(module)) + s);
        }
    }

    public static void println(String module, Class c, String s, String component) {
        if (ACTIVE_MODULES.contains(module)) {
            DebugPrinter.println(c, String.valueOf(DebugPrinter.getModulePrefix(module)) + s, component);
        }
    }

    public static void println(Class c, String s, String component) {
        DebugPrinter.println(String.valueOf(DebugPrinter.getClassPrefix(c)) + s);
    }

    public static void println(String module, Object o, String s) {
        if (ACTIVE_MODULES.contains(module)) {
            DebugPrinter.println(o.getClass(), String.valueOf(DebugPrinter.getModulePrefix(module)) + s);
        }
    }

    public static void println(String module, String s) {
        if (ACTIVE_MODULES.contains(module)) {
            DebugPrinter.println(String.valueOf(DebugPrinter.getModulePrefix(module)) + s);
        }
    }

    public static void stamp(String s) {
        DebugPrinter.println("<" + System.currentTimeMillis() + " | " + Thread.currentThread().hashCode() + " >" + s);
    }

    public static String getClassName(Class c) {
        String fullName = c.getName();
        return fullName.substring(fullName.lastIndexOf(".") + 1);
    }

    public static void stamp(Class c, String s) {
        DebugPrinter.println(System.currentTimeMillis() + " | " + DebugPrinter.getClassName(c) + ": " + s);
    }

    public static void stamp(String module, Class c, String s) {
        DebugPrinter.println(String.valueOf(DebugPrinter.getModulePrefix(module)) + System.currentTimeMillis() + " | " + DebugPrinter.getClassName(c) + ": " + s);
    }

    public static void exception(Throwable t) {
        if (DEBUG) {
            System.err.println("[JRockit] DEBUG Stack trace from exception in Management Server.");
            t.printStackTrace();
            System.err.flush();
        }
    }

    public static PrintStream getErr() {
        return m_err;
    }

    public static PrintStream getOut() {
        return m_out;
    }

    public static void setErr(PrintStream err) {
        m_err = err;
    }

    public static void setOut(PrintStream out) {
        m_out = out;
    }
}

