/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.rmp;

import com.jrockit.common.rmp.JRockitConnectionRefusedException;

public class JRockitTooManyConnectionsException
extends JRockitConnectionRefusedException {
    private static final long serialVersionUID = -4122175996802935382L;
    private int m_maxNumber;

    public JRockitTooManyConnectionsException(int maxNumber) {
        super("Connection refused. Maximum number (" + maxNumber + ") of allowed connections to JRockit exceeded.");
        this.m_maxNumber = maxNumber;
    }

    public int getMaxNumber() {
        return this.m_maxNumber;
    }

    public String getHelpfulMessage() {
        return "Too many concurrent connections to server. The connection to JRockit Management Server was refused, since the maximum number of allowed concurrent connections (currently " + this.getMaxNumber() + ") " + "on the server is already reached. " + "The maximum number of connections on the server can be changed by passing " + "the setting jrockit.managementserver.maxconnect=<maximum number of connections> " + "to JRockit. You can also check if there are other instances of the " + "Management Console which you don't need that connects to this server.";
    }
}

