/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types.visitor;

import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckSetter
implements IVisitor {
    private final boolean m_state;
    private List<TypeDescriptor> m_checked = new ArrayList<TypeDescriptor>();
    private List<TypeDescriptor> m_unchecked = new ArrayList<TypeDescriptor>();

    public CheckSetter(boolean state) {
        this.m_state = state;
    }

    @Override
    public void visit(TypeFolder folder) {
        for (IVisitable v : folder.getChildren()) {
            v.accept(this);
        }
    }

    @Override
    public void visit(TypeDescriptor typeDescriptor) {
        boolean currentStatus = typeDescriptor.isChecked();
        if (this.m_state != currentStatus) {
            typeDescriptor.setChecked(this.m_state);
            if (this.m_state) {
                this.m_checked.add(typeDescriptor);
            } else {
                this.m_unchecked.add(typeDescriptor);
            }
        }
    }

    public List<TypeDescriptor> getChecked() {
        return this.m_checked;
    }

    public List<TypeDescriptor> getUnChecked() {
        return this.m_unchecked;
    }
}

