/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitor;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.PathFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeRespository
implements IVisitable {
    private static final String ROOT_FOLDER = "rootFolder";
    private static final String LINE_BREAK = "\n";
    private final Setting m_setting = new Setting("typeRepository");
    static boolean first;

    static {
        PersistenceToolkit.registerFetcher(TypeRespository.class, (ISettingFetcher)new ISettingFetcher<TypeRespository>(){

            public Setting getSetting(TypeRespository typeRespository) {
                return typeRespository.m_setting;
            }
        });
        first = true;
    }

    public TypeFolder getRootFolder() {
        return (TypeFolder)this.m_setting.getChildObject(ROOT_FOLDER, TypeFolder.class);
    }

    public void addTypeDescriptor(TypeDescriptor typeDescriptor) {
        PathFinder pf = new PathFinder(typeDescriptor.getPath());
        this.accept(pf);
        TypeDescriptor td = pf.getTypeDescriptor();
        if (td == null) {
            this.addTypeFolder(this.getRootFolder(), 0, this.split(typeDescriptor.getPath()), typeDescriptor);
            td = typeDescriptor;
        }
        td.setDiscovered(true);
    }

    private void addTypeFolder(TypeFolder parent, int index, List<String> pathElementNames, TypeDescriptor typeDescriptor) {
        if (index < pathElementNames.size()) {
            String path = this.buildPath(index, pathElementNames);
            this.addTypeFolder(parent.getOrCreateFolderFromPath(path), index + 1, pathElementNames, typeDescriptor);
        } else {
            for (TypeDescriptor d : parent.getTypeDescriptors()) {
                if (!d.getPath().equals(typeDescriptor.getPath())) continue;
                return;
            }
            parent.getTypeDescriptors().add(typeDescriptor);
        }
    }

    private String buildPath(int index, List<String> pathElementNames) {
        String path = pathElementNames.get(0);
        int i = 0;
        while (i < index) {
            path = String.valueOf(path) + "/" + pathElementNames.get(i + 1);
            ++i;
        }
        return path;
    }

    private List<String> split(String path) {
        ArrayList<String> tokenLIst = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreElements()) {
            tokenLIst.add((String)st.nextElement());
        }
        tokenLIst.remove(tokenLIst.size() - 1);
        return tokenLIst;
    }

    @Override
    public void accept(IVisitor visistor) {
        this.getRootFolder().accept(visistor);
    }

    public String toString() {
        return this.prettyPrint("", this.getRootFolder(), false);
    }

    private String prettyPrint(String indent, TypeFolder folder, boolean description) {
        indent = String.valueOf(indent) + "  ";
        String result = String.valueOf(this.pad(String.valueOf(indent) + "[" + folder.getName() + "]")) + (description ? "|" : "") + LINE_BREAK;
        for (TypeDescriptor t : folder.getTypeDescriptors()) {
            result = String.valueOf(result) + this.pad(String.valueOf(indent) + "  " + t.getName()) + (description ? "|" + t.getDescription() : "") + LINE_BREAK;
        }
        for (TypeFolder f : folder.getFolders()) {
            result = String.valueOf(result) + this.pad(this.prettyPrint(indent, f, description));
        }
        return result;
    }

    private String pad(String string) {
        while (string.length() < 60) {
            string = String.valueOf(string) + " ";
        }
        return string;
    }
}

