/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.misc.ui.ColorProvider;
import com.jrockit.mc.core.ui.IToolTipTextProvider;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.MatchingVisitor;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

final class TypeLabelProvider
extends LabelProvider
implements IToolTipTextProvider,
IFontProvider {
    private final ColorProvider m_colorProvider;
    private final MatchingVisitor m_matchingVisitor;

    public TypeLabelProvider(ColorProvider colorProvider, MatchingVisitor matchingVisitor) {
        this.m_colorProvider = colorProvider;
        this.m_matchingVisitor = matchingVisitor;
    }

    public void dispose() {
        this.m_colorProvider.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof TypeFolder) {
            return CorePlugin.getDefault().getImage("fldr_obj.gif");
        }
        if (element instanceof TypeDescriptor) {
            TypeDescriptor td = (TypeDescriptor)element;
            this.m_colorProvider.registerColor((Object)td.getPath(), ((TypeDescriptor)element).getColor());
            return this.m_colorProvider.getImage((Object)td.getPath());
        }
        return null;
    }

    public String getToolTipText(Object element) {
        String description = this.getDescriptionText(element);
        if (description == null || description.length() == 0) {
            return this.getText(element);
        }
        return description;
    }

    private String getDescriptionText(Object element) {
        if (element instanceof TypeFolder) {
            return ((TypeFolder)element).getDescription();
        }
        if (element instanceof TypeDescriptor) {
            return ((TypeDescriptor)element).getDescription();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TypeFolder) {
            return ((TypeFolder)element).getName();
        }
        if (element instanceof TypeDescriptor) {
            return ((TypeDescriptor)element).getName();
        }
        return null;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
    }

    public Font getFont(Object element) {
        if (!this.m_matchingVisitor.getMatchAll() && this.m_matchingVisitor.isMatch((IVisitable)element)) {
            return CorePlugin.getDefault().getFontColorToolkit().getBoldTableFont();
        }
        return null;
    }
}

