/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.design.DesignEditor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.core.AdapterUtil;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ComponentPage;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.MessagePage2;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class EventTypesView
extends PageBookView
implements IPageChangedListener {
    public static final String ID = "com.jrockit.mc.flightrecorder.ui.views.types.EventTypesView";
    private IPageChangeProvider m_lastEditor;
    private Object m_lastPage;

    public void partActivated(IWorkbenchPart part) {
        if (this.isImportant(part)) {
            IPageChangeProvider pageChanger = (IPageChangeProvider)AdapterUtil.getAdapter((Object)part, IPageChangeProvider.class);
            if (this.m_lastEditor != null) {
                this.m_lastEditor.removePageChangedListener((IPageChangedListener)this);
                this.m_lastEditor = null;
                this.m_lastPage = null;
            }
            this.m_lastEditor = pageChanger;
            this.m_lastEditor.addPageChangedListener((IPageChangedListener)this);
            super.partActivated(part);
            this.pageChanged(part, pageChanger.getSelectedPage());
        }
    }

    private void pageChanged(IWorkbenchPart part, Object page) {
        if (page != this.m_lastPage) {
            this.m_lastPage = page;
            PageBookView.PageRec rec = this.getPageRec(part);
            if (rec != null && rec.page instanceof ComponentPage) {
                this.updatePage(part, (ComponentPage)rec.page);
            }
        }
    }

    private void updatePage(IWorkbenchPart part, ComponentPage cp) {
        UIScope scope = (UIScope)AdapterUtil.getAdapter((Object)part, UIScope.class);
        if (scope != null && this.allowsTypeChange(scope)) {
            cp.show();
        } else {
            cp.hide();
        }
    }

    private boolean allowsTypeChange(UIScope uiScope) {
        for (ITypeVisibilityChange change : uiScope.getCompatibles(ITypeVisibilityChange.class)) {
            if (!change.isTypeChangeEnabled()) continue;
            return true;
        }
        return false;
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage2 mp = new MessagePage2();
        mp.setMessage(Messages.TYPE_COMPONENT_NONE_FILTERABLE_TAB_TEXT);
        this.initPage((IPageBookViewPage)mp);
        mp.createControl((Composite)book);
        return mp;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof DesignEditor) {
            DesignEditor editor = (DesignEditor)part;
            IServiceLocator s = editor.getServiceLocator();
            ComponentPage p = new ComponentPage(s);
            this.initPage((IPageBookViewPage)p);
            p.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)p);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (part instanceof DesignEditor) {
            pageRecord.page.dispose();
            pageRecord.dispose();
            if (this.m_lastEditor == part) {
                this.m_lastEditor = null;
                this.m_lastPage = null;
            }
        }
    }

    public void dispose() {
        if (this.m_lastEditor != null) {
            this.m_lastEditor.removePageChangedListener((IPageChangedListener)this);
            this.m_lastPage = null;
        }
        this.m_lastEditor = null;
        super.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart part;
        IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
        if (page != null && this.isImportant((IWorkbenchPart)(part = page.getActiveEditor()))) {
            return part;
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DesignEditor;
    }

    public void pageChanged(PageChangedEvent event) {
        this.pageChanged((IWorkbenchPart)this.m_lastEditor, event.getSelectedPage());
    }
}

