/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.sampler;

import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.ITrackView;
import com.jrockit.mc.flightrecorder.ui.sampler.ISampler;
import com.jrockit.mc.flightrecorder.ui.sampler.SampleInfo;

public class TrackSampler
implements ISampler {
    private SampleInfo m_info = new SampleInfo(0);
    private ITrackView m_collection;

    public boolean needsStructuralRefresh(IRange range, int width) {
        if (this.m_info.isStructuralDirty()) {
            return true;
        }
        if (width != this.m_info.getSize()) {
            return true;
        }
        if (range.getStartTimestamp() != this.m_info.getRange().getStartTimestamp()) {
            return true;
        }
        return range.getEndTimestamp() != this.m_info.getRange().getEndTimestamp();
    }

    public SampleInfo getSampleInfo() {
        return this.m_info;
    }

    public void setInput(Object input) {
        this.m_collection = (ITrackView)input;
    }

    public final void sample(IRangeFilter filter) {
        int size = this.m_info.getSize();
        if (size > 0) {
            IRange theSampleRange = this.getSampleInfo().getRange();
            long length = theSampleRange.getEndTimestamp() - theSampleRange.getStartTimestamp();
            long sampleRangeStart = theSampleRange.getStartTimestamp();
            if (length > 0L) {
                double length_per_pixel = (double)size / (double)length;
                this.m_collection.setFilter(filter);
                this.m_collection.setExpansion(RangeSelection.NORMAL);
                this.m_collection.setRange(theSampleRange);
                for (IRange range : this.m_collection) {
                    this.addLayer(range, (double)(range.getStartTimestamp() - sampleRangeStart) * length_per_pixel, (double)(range.getEndTimestamp() + 1L - sampleRangeStart) * length_per_pixel, size);
                }
                this.getSampleInfo().setStructuralDirty(false);
            }
        }
    }

    private final void addLayer(IRange e, double startPixel, double endPixel, int size) {
        int endSlot;
        double sp = startPixel < 0.0 ? 0.0 : startPixel;
        double ep = endPixel > (double)(size - 1) ? (double)(size - 1) : endPixel;
        int startSlot = startPixel < 0.0 ? 0 : (int)startPixel;
        int n = endSlot = endPixel < (double)(size - 1) ? (int)endPixel : size - 1;
        if (startSlot < size && endSlot >= 0) {
            if (startSlot == endSlot) {
                this.m_info.addSample(startSlot, ep - sp, e);
            } else {
                this.m_info.addSample(startSlot, 1.0 - (sp - (double)startSlot), e);
                this.m_info.addSample(endSlot, ep - (double)endSlot, e);
                int n2 = startSlot + 1;
                while (n2 < endSlot) {
                    this.m_info.addSample(n2, 1.0, e);
                    ++n2;
                }
            }
        }
    }
}

